/***********************************************************************
 *
 * Copyright (C) 2010-2011 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#ifndef TAULER_H
#define TAULER_H

#include <QGraphicsView>
#include <QHash>
#include <QtGui>
#include "constants.h"

class Fitxa;
class frmPrincipal;
class Rellotge;

class Tauler: public QGraphicsView
{
public:
    Tauler( QUndoStack  *movimentsUndoStack, Rellotge *rellotge,frmPrincipal *frmPrinci, QWidget* parent = 0);

    //QGraphicsScene* sceneJoc;

    void joc_llegeixArxiuData();
    void joc_CarregaJoc( QString p_tipusJoc, QString p_filesColumnes, QString p_estatFitxes);

    int estatFitxaJoc(const  QPoint& coordenades) const ;

    void marcaMovimentsFitxa(QList<QPoint> movimentsFitxa);
    void eliminaMarquesMoviments(const  QPoint& coordenades);
    void ferMoviment (int fitxaInicial, int fitxaBotada, int fitxaFinal);
    void marcaFinalDeJoc(int direccioMoviment=1);

    //Canvia l'estat de les fitxes per tal de marcar un moviment
    void marcaMoviment (QString moviment);


    QHash<int, Fitxa*> m_fitxes;

    QUndoStack  *p_movimentsUndoStack;

    Rellotge *p_rellotge;

    int comptadorFitxesJoc;

    void eliminaFitxesVermelles();

    void solucionaJocActual_CalculaMovimentsPosibles();
    QStringList solucionaJocActual_CarregaMovimentsArbre(QStringList movimentsFets, QString darrerMoviment);
    QStringList solucionaJocActual_CalculaNumeroMovimentsPosteriors(QStringList movimentsPosibles);
    //Comprova si, desprès de fer el moviment passat per paràmetre,
    //és possible fer altres moviments
    bool solucionaJocActual_CalculaMovimentsPosteriors(QString moviment);
    int solucionaJocActual_MovimentsPosiblesActuals();

    bool solucionaJocActual_FitxesAillades();
    bool movimentPosibleFitxaFinal(int fitxaMijana);
    bool movimentPosibleFitxaFinal1(int fitxaMijana);
    bool movimentPosibleFitxaMitjana(int fitxaMitjana);
    //No es fa servir
  //  bool movimentFitxaCentral();

    QString configuracioActual(bool comptarFitxes=false);

    //Carrega la configuració passada
    void carregaConfiguracio(QString configuracio);

    //Canvia l'estat de les fitxes a l'atzar
    //Es fa servir quan el joc està en pausa
    void estatFitxesAtzar();

    int numeroDeMovimentsJoc();

    //No es fa servir
   // QString missatgeNumeroMoviments();

    QString p_modalitatJocActual;

    void setEstatDelJoc(EstatsDelJoc valor);

    EstatsDelJoc estatDelJoc() const{
        return p_estatDelJoc;}


    //Numero de fitxes aïllades permeses per a cada modalitat
    int p_numFitxesAillades;
    //Número de moviments a "conservar" en cercar una  nova solució
    //a partir d'una altra
    int p_numMoviments;


    //TIpus de moviment del joc actual
    int p_tipusMoviment;



 protected:
    virtual void resizeEvent(QResizeEvent* event);

 private:

    frmPrincipal *p_frmPrinci;


    int p_estatFitxaMitjana;

    bool jocFinalitzat();

    void controlaRecords();

    EstatsDelJoc p_estatDelJoc;
};

#endif // TAULER_H
