/***********************************************************************
 *
 * Copyright (C) 2010-2011 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#include <QtGui>


#include "fitxa.h"
#include "tauler.h"
#include "rellotge.h"

Fitxa::Fitxa(Tauler*  taulerJoc, QGraphicsItem* parent)
         : QGraphicsEllipseItem(0, 0, 30, 30, parent),
         m_taulerJoc(taulerJoc)
{
    m_estat=1; //Estat inicial normal
    p_tipusMoviment=1;
    p_esMou=false;
    p_aillada=false;
    p_nivellAillament=0;
}


void Fitxa::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,  QWidget *){

 QLinearGradient gradientLinear(0, 0, 0, 30);
 gradientLinear.setColorAt(0, QColor(Qt::white));
 gradientLinear.setColorAt(1, QColor(Qt::blue));
 painter->setBrush(gradientLinear);

 QRadialGradient gradientRadial(QPointF( 15,15),15);
 gradientRadial.setColorAt(0, QColor(Qt::white));
 gradientRadial.setColorAt(1, QColor(Qt::lightGray));

 switch (m_estat) {
     case 0: // Lloc buit
       painter->setBrush(gradientRadial);
       painter->setPen( Qt::NoPen );
       break;
     case 1:  //estat normal de la fitxa
       painter->setPen( Qt::blue );
       break;
     case 2: //Fitxa Seleccionada per a un moviment
       gradientLinear.setColorAt(1, QColor(Qt::yellow));
       painter->setBrush(gradientLinear);
       painter->setPen( Qt::NoPen );
       break;
     case 3: //destí d'un moviment
       painter->setBrush(gradientRadial);
       painter->setPen(QPen(Qt::red, 4));
       break;
     case 4: //Fitxa a final de joc resolt
       gradientLinear.setColorAt(1, QColor(Qt::green));
       painter->setBrush(gradientLinear);
       painter->setPen( Qt::NoPen );
       break;
     case 5: //El joc s'ha acabat ja que no hi ha més moviments
       gradientLinear.setColorAt(1, QColor(Qt::red));
       painter->setBrush(gradientLinear);
       painter->setPen( Qt::NoPen );
       break;
     default: //estat normal de la fitxa
       painter->setPen( Qt::blue );

 }
 /*
 if (p_esMou){
     painter->drawRect(0,0,30,30);
 }
 */

 /*
 if (p_aillada){
     gradientLinear.setColorAt(1, QColor(Qt::yellow));
       painter->setBrush(gradientLinear);
 }
 */

  painter->drawEllipse( 0, 0, 30,30 );
}

void Fitxa::mousePressEvent(QGraphicsSceneMouseEvent* event) {
    if ( (event->modifiers().testFlag ( Qt::ControlModifier ))
        && !(m_taulerJoc->p_rellotge->rellotgeEnMarxa()) ){
        //S'està plantejant un "problema". Només canviam l'estat
        //de la fitxa
        switch (m_estat) {
            case 0:
              setEstat(1);
              break;
            case 1:
              setEstat(0);
              break;
        }
    }
    else{
   if ( !m_taulerJoc->p_rellotge->rellotgeEnMarxa()){
       m_taulerJoc->p_rellotge->iniciaRellotge();
      m_taulerJoc->p_movimentsUndoStack->clear();}
   switch (m_estat) {
       case 3: // Lloc buit final d'un moviment. La fitxa és el destí d'un moviment que cal fer
           ferMoviment();
           //Eliminam marques de moviments
           m_taulerJoc->eliminaMarquesMoviments(m_coordenades);
           break;
       case 1: //Fitxa activa. Cal iniciar un moviment
           setEstat(2);
           calculaMovimentsFitxa();
           m_taulerJoc->marcaMovimentsFitxa(movimentsFitxa);
           break;
       case 2: // Fitxa seleccionada prèviament per a un moviment. S'anula la selecció
           setEstat(1);
           //Eliminam marques de moviments anteriors
           m_taulerJoc->eliminaMarquesMoviments(m_coordenades);
           break;
   }
}
QGraphicsEllipseItem::mousePressEvent(event);
}

bool Fitxa::esPotMoure(){
    calculaMovimentsFitxa();
    return movimentsFitxa.size()>0;
}

/*
  Calcula els possibles moviments de la fitxa i els conserva
  a la llista movimentsFitxa
  */
void Fitxa::calculaMovimentsFitxa(){
    movimentsFitxa.clear();
    int estatFitxaFinal = 0;
    int estatFitxaBotada = 1;
    switch (p_tipusMoviment) {
     case 2:
         estatFitxaBotada = 0;
         break;
     }
    //Eliminam marques de moviments anteriors
    m_taulerJoc->eliminaMarquesMoviments(m_coordenades);
    for (int fila = -1; fila < 2; ++fila) {
                for (int columna = -1; columna < 2; ++columna) {
                    QPoint coord(fila,columna);
                    if( ( (m_taulerJoc->estatFitxaJoc(coord*2+m_coordenades)==estatFitxaFinal) &&
                        (m_taulerJoc->estatFitxaJoc(coord+m_coordenades)==estatFitxaBotada) ) )
                        {
                        //Això per garantir que la fitxa destí està a la mateixa fila o columna que la clicada
                        if(  (columna*2+m_coordenades.x()==m_coordenades.x()
                            || fila*2+m_coordenades.y()==m_coordenades.y()) &&  (p_tipusMoviment != 3)  ) {
                           movimentsFitxa.append(coord*2+m_coordenades)  ;
                           }
                        //estan permesos els movimens en diagonal
                        else if (p_tipusMoviment==3){
                           movimentsFitxa.append(coord*2+m_coordenades)  ;
                        }
                    }
                }
            }
}

/*
  Realitza un moviment del qual la fitxa actual és el destí
  */
void Fitxa::ferMoviment(){
    int estatFitxaInicial =2; //fitxa marcada com a destí del moviment
    int estatFitxaBotada = 1;
    switch (p_tipusMoviment) {
     case 2:
         estatFitxaBotada = 0;
         break;
     }
    for (int fila = -1; fila < 2; ++fila) {
                for (int columna = -1; columna < 2; ++columna) {
                    QPoint coord(fila,columna);
                    if( ( (m_taulerJoc->estatFitxaJoc(coord*2+m_coordenades)==estatFitxaInicial) &&
                        (m_taulerJoc->estatFitxaJoc(coord+m_coordenades)==estatFitxaBotada) ) )
                        {
                        //Això per garantir que la fitxa destí està a la mateixa fila o columna que la clicada
                        if(  (columna*2+m_coordenades.x()==m_coordenades.x()
                            || fila*2+m_coordenades.y()==m_coordenades.y()) &&  (p_tipusMoviment != 3) ){
                          m_taulerJoc->ferMoviment( (coord*2+m_coordenades).x()*100+(coord*2+m_coordenades).y(),
                                                 (coord+m_coordenades).x()*100+(coord+m_coordenades).y(),
                                                 m_coordenades.x()*100+m_coordenades.y());
                         }
                        //estan permesos els movimens en diagonal
                        else if (p_tipusMoviment==3){
                           m_taulerJoc->ferMoviment( (coord*2+m_coordenades).x()*100+(coord*2+m_coordenades).y(),
                                                 (coord+m_coordenades).x()*100+(coord+m_coordenades).y(),
                                                 m_coordenades.x()*100+m_coordenades.y());
                        }
                    }
                }
            }
}

void Fitxa::calculaMovimentsPosiblesFitxa(){
    movimentsPossibles.clear();
    for (int fila = -1; fila < 2; ++fila) {
                for (int columna = -1; columna < 2; ++columna) {
                    QPoint coord(fila,columna);
                    if(  (m_taulerJoc->estatFitxaJoc(coord*2+m_coordenades)>-1) &&
                        (m_taulerJoc->estatFitxaJoc(coord+m_coordenades)>-1)  &&
                        (coord != QPoint(0,0)))
                        {
                        //Això per garantir que la fitxa destí està a la mateixa fila o columna que la clicada
                        if(  (columna*2+m_coordenades.x()==m_coordenades.x()
                            || fila*2+m_coordenades.y()==m_coordenades.y()) &&  (p_tipusMoviment != 3) ) {
                           //posam l'index de la fitxa botada i de la fitxa final
                           movimentsPossibles.append(QPoint(
                                 (coord+m_coordenades).x()*100+(coord+m_coordenades).y(),
                                 (coord*2+m_coordenades).x()*100+(coord*2+m_coordenades).y() ));                                 
                           }
                        //estan permesos els movimens en diagonal
                        else if (p_tipusMoviment==3){//posam l'index de la fitxa botada i de la fitxa final
                           movimentsPossibles.append(QPoint(
                                 (coord+m_coordenades).x()*100+(coord+m_coordenades).y(),
                                 (coord*2+m_coordenades).x()*100+(coord*2+m_coordenades).y() ));
                        }
                    }
                }
            }
 setPreferenciaMoure(movimentsPossibles.count());
}

/*************************************************/
//GESTIÓ DE LES PROPIETATS DE LA FITXA

/*
  Lectura de la propietat estat
  */
/*
int Fitxa::estat() const
{
  return m_estat;
}
*/
/*
  Estableix el valor de l'estat
  */
void Fitxa::setEstat( int nuoValor )
{
  if( (nuoValor < 0)  || (nuoValor >  5))
    m_estat = 0;
  if( m_estat != nuoValor ){
     m_estat = nuoValor;
     //Si la fitxa es "mou", llavors reinciam l'aïllament
     if(m_estat==0) {setFixaAillada(false);}
  update();}
}

QPoint Fitxa::coordenades() const{
    return m_coordenades;
}
/*
  Estableix les coordenades de la fitxa en el joc
  */
void  Fitxa::setCoordenades (QPoint coordenades){
    m_coordenades = coordenades;
    update();
   setToolTip(QString("(%1,%2)").arg(m_coordenades.x()).
                      arg(m_coordenades.y()));
}

/*
  Indica la preferència en moure la fitxa en el joc
  */
void Fitxa::setPreferenciaMoure(int preferencia){
    if( p_preferenciaMoure != preferencia ){
        p_preferenciaMoure = preferencia;}
}

/*
           Controla el tipus de moviment
           1: moviment directa (l'habitual del joc)
           2: moviment invers
           3: moviment en direcció perpendicular i obliqua
           4: proposta de problema
           */
void Fitxa::setTipusMoviment (int nouTipus){
  if( (nouTipus < 0)  || (nouTipus >  4))
    p_tipusMoviment = 0;
  if( p_tipusMoviment != nouTipus ){
      p_tipusMoviment = nouTipus;}
}

void Fitxa::setEsMou(bool valor){
    if(p_esMou != valor){
      p_esMou=valor;
    }
}

void Fitxa::setFixaAillada(bool valor){
    if(p_aillada != valor){
        p_aillada=valor;
        p_nivellAillament=0;
        update();}
  if (p_aillada){incrementaNivellAillament();}
}


void Fitxa::setNivellAillament( int valor){
    if(p_nivellAillament != valor){
        p_nivellAillament=valor;}
  }

void Fitxa::incrementaNivellAillament(){
    ++p_nivellAillament;
}

