#include <config.h>
#include <pthread.h>
#include <stdio.h>
#include "../netdev.h"
#include "../ipvers.h"

#if !defined(lint) && !defined(NO_RCSIDS)
static char rcsid[]="$Id: is_local_addr.c,v 1.1 2000/07/20 20:03:25 thomas Exp $";
#endif

int daemon_p=0;
int debug_p=0;
int verbosity=VERBOSITY;
pthread_t main_thread;

int run_ipv4=DEFAULT_IPV4;
int run_ipv6=DEFAULT_IPV6;

int main(int argc, char *argv[]) 
{
	pdnsd_a a;
	
	if (argc!=2) {
		printf("Usage: %s <address>\n",argv[0]);
		exit(1);
	}
#ifdef ENABLE_IPV4
	if (inet_aton(argv[1],&a.ipv4)) {
		run_ipv4=1;
		run_ipv6=0;
		printf("is %s a local addr: %s\n",argv[1],is_local_addr(&a)?"yes":"no");
		return 0;
	}
#endif
#ifdef ENABLE_IPV6
	if (inet_pton(AF_INET6,argv[1],&a.ipv4)) {
		run_ipv4=0;
		run_ipv6=1;
		printf("is %s a local addr: %s\n",argv[1],is_local_addr(&a)?"yes":"no");
		return 0;
	}
#endif
	printf("Adress invalid.\n");
	return 0;
}
