/*
 * dialog_filechooser_extension.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dialog_filechooser_extension.h"


/*** Expander : Cat Options ***************************************************/

// Constructor - ComboBox : Cat Options - Even Odd
cCBox_CatOptions_EvenOdd::cCBox_CatOptions_EvenOdd()
{
	rLStore		= cLStore_EvenOdd::create();
	pTMCRecord	= rLStore->getTMCRecord();

	pack_start( mCRText );
	add_attribute( mCRText.property_text() , pTMCRecord->mTMColumn_Label );	// necessarily after 'pack_start()' !!!
	set_model( rLStore );
	set_active( 0 );
}


// Destructor - ComboBox : Cat Options - Even Odd
cCBox_CatOptions_EvenOdd::~cCBox_CatOptions_EvenOdd()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cCBox_CatOptions_EvenOdd::~cCBox_CatOptions_EvenOdd()";	//TEST
#endif
}


// Constructor - ComboBox : Cat Options - Rotation
cCBox_CatOptions_Rotation::cCBox_CatOptions_Rotation()
{
	rLStore		= cLStore_Rotation::create();
	pTMCRecord	= rLStore->getTMCRecord();

	pack_start( mCRText );
	add_attribute( mCRText.property_text() , pTMCRecord->mTMColumn_Label );
	set_model( rLStore );
	set_active( 0 );
}


// Destructor - ComboBox : Cat Options - Rotation
cCBox_CatOptions_Rotation::~cCBox_CatOptions_Rotation()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cCBox_CatOptions_Rotation::~cCBox_CatOptions_Rotation()";	//TEST
#endif
}


// Constuctor - Expander : Cat Options
cExpander_CatOptions::cExpander_CatOptions()
:
	Gtk::Expander( _("_Options") , true ),		// label , mnemonic
	mHBox_Options( false , Pdfchain::SPACING ),	// homogenous , spacing
	mLabel_Pages( _("Pages:") , false ),		// label , mnemonic
	mLabel_Rotation( _("Rotation:") , false ),
	mLabel_Password( _("Password:") , false ),
	sPages( "1-end" )
{
	mEntry_Pages.set_text( sPages );
	mEntry_Pages.set_icon_from_stock(		Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );
	mEntry_Password.set_icon_from_stock(	Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );

	mHBox_Options.pack_start( mLabel_Pages		, false	, false	, Pdfchain::PADDING );	// widget , expand , fill , padding
	mHBox_Options.pack_start( mEntry_Pages		, true	, true	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mCBox_EvenOdd		, false	, false	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mSeparator_A		, false	, false	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mLabel_Rotation	, false	, false	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mCBox_Rotation	, false	, false	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mSeparator_B		, false	, false	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mLabel_Password	, false	, false	, Pdfchain::PADDING );
	mHBox_Options.pack_start( mEntry_Password	, true	, true	, Pdfchain::PADDING );

	add( mHBox_Options );
	show_all_children();

	mEntry_Pages.signal_icon_press().connect(		sigc::mem_fun( *this , &cExpander_CatOptions::onEntryIcon_Pages_pressed		) );
	mEntry_Password.signal_icon_press().connect(	sigc::mem_fun( *this , &cExpander_CatOptions::onEntryIcon_Password_pressed	) );
}

// Destructor - Expander : Cat Options
cExpander_CatOptions::~cExpander_CatOptions()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cExpander_CatOptions::~cExpander_CatOptions()";	//TEST
#endif
}