/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Main
 src/main.cc
 *******************************************/

#include "definings.hh"
#include "mainwindow.hh"
#include "dialogs.hh"

/*** Main ***/
int main(int argc, char *argv[]){
	
	Gtk::Main kit(argc, argv);
	class_window_main window_main;
	Gtk::Main::run(window_main);
	
	return 0;
}



/*** Execute PDFTK Command ***/
bool execute(Gtk::Window* pt_parent, Glib::ustring command){
	
	int i = -1;
	bool error = false;
	std::string str_command;
	class_dialogs* pt_dialogs = new class_dialogs();
	
	// Test for ASCII
	if(command.is_ascii() == true){
		
		std::cout << std::endl << command.c_str(); // Output
		i = system(command.c_str());               // Execute Command
		
		// Test for PDFTK-Error
		if( i != 0){
			
			// On Error
			error = true;
			
			// Error Messages
			//pt_dialogs->error_cerr("class_dialogs::execute_command()", Text::err_PDFTK, i);
			pt_dialogs->error_cerr("class_dialogs::execute_command()", Text::err_PDFTK, Text::err_msg_NO_OUTPUT_CREATED);
			std::cerr << ": " << Text::str_QUOTE_BEGIN << i << Text::str_QUOTE_END;
			
			pt_dialogs->error_message(pt_parent, Text::str_PDFTK, Text::err_PDFTK);
		}
		else{
			
			// Info Message
			pt_dialogs->info_message(pt_parent, Text::str_PDFTK, Text::msg_PDFTK);
		}
		
	}
	else{
		error = true;
		
		// Error Messages
		pt_dialogs->error_cerr("class_dialogs::execute_command()", Text::err_ASCII, command);
		pt_dialogs->error_message(pt_parent, Text::str_ASCII, Text::err_ASCII);
	}
	
	std::cout << std::endl;
	return error;
}



/*** Quoting (known) Special Characters for PDFTK ***/
Glib::ustring quote_out(Glib::ustring str){
	
	Glib::ustring::size_type pos = 0, next_pos = 0;
	
	// Quoting ' '
	pos = next_pos = 0;
	do{
		pos = str.find(" ", next_pos, 1);
		
		if(pos != Glib::ustring::npos){
			str.insert(pos, "\\");
			next_pos = pos + 2;
		}
		
	}while(pos != Glib::ustring::npos);
	
	// Quoting ')'
	pos = next_pos = 0;
	do{
		pos = str.find(")", next_pos, 1);
		
		if(pos != Glib::ustring::npos){
			str.insert(pos, "\\");
			next_pos = pos + 2;
		}
	}while(pos != Glib::ustring::npos);
		
	// Quoting '('
	pos = next_pos = 0;
	do{
		pos = str.find("(", next_pos, 1);
					   
		if(pos != Glib::ustring::npos){
			str.insert(pos, "\\");
			next_pos = pos + 2;
		}
					   
	}while(pos != Glib::ustring::npos);
		
	return str;
}
		
		
		
/*** Get Pagenumber (loads and counts pages from a PDF) ***/
unsigned int get_pagenumber(Glib::ustring filename){
	
	unsigned int pages = 0;
	Glib::ustring ustring_file_contents;
	Glib::ustring::size_type pos = 0;
	Glib::RefPtr<Gio::File> file = Gio::File::create_for_path(filename);
	
	if(file->query_exists() == true){
		
		Glib::RefPtr<Gio::FileInputStream> stream = file->read();
		char read_buffer[BUFFER_SIZE];
		gssize bytes_read = 0;
		
		// Read PDF
		do{
			bytes_read = stream->read (read_buffer, sizeof (read_buffer));
			ustring_file_contents += Glib::ustring(read_buffer, read_buffer + bytes_read);
			
		}while(bytes_read != 0);
		
		stream->close();
		
		// Searching for Strings
		pos = 0;
		while(pos != Glib::ustring::npos){
			if((pos = ustring_file_contents.find(STRING_AT_PDF1, pos)) != Glib::ustring::npos){
				
				pages++;
				pos++;
			}
		}
		
		pos = 0;
		while(pos != Glib::ustring::npos){
			if((pos = ustring_file_contents.find(STRING_AT_PDF2, pos)) != Glib::ustring::npos){
				
				pages++;
				pos++;
			}
		}
		
		pos = 0;
		while(pos != Glib::ustring::npos){
			if((pos = ustring_file_contents.find(STRING_AT_PDF3, pos)) != Glib::ustring::npos){
				
				pages--;
				pos++;
			}
		}
		
		pos = 0;
		while(pos != Glib::ustring::npos){
			if((pos = ustring_file_contents.find(STRING_AT_PDF4, pos)) != Glib::ustring::npos){
				
				pages--;
				pos++;
			}
		}
	}
	
	if(pages == 0){    
		// Error Message
		//dialogs.error_cerr("class_window_main::get_pagenumber()", Text::err_FILE_HAS_NO_PAGES, filename);
	}
	
	return pages;
}



/*** Get Filnemame (cut out form whole Path) ***/
Glib::ustring get_filename(Glib::ustring sourcepath){
	
	Glib::ustring filename;
	Glib::ustring::size_type pos = 0;
	
	if((pos = sourcepath.rfind('/')) != Glib::ustring::npos){
		
		filename = sourcepath;
		filename.erase(0, pos+1);
	} 
	
	return filename;
}



/*** Get ustring form unsigned int ***/
Glib::ustring get_ustring_from_unsigned_int(unsigned int i){
	
	Glib::ustring str;
	
	if(i == 0){
		str = "0";
	}
	else{
		
		while(i != 0){
			str.insert(0, 1, i%10 + '0'); 
			i /= 10;
		}
	}
	
	return str;
}


/*** Get an upper case letter (0=A - 25=Z) ***/
char get_letter(unsigned int n){
	
	if(n >= FILES_MAX){
		
		// Error Message
		//dialogs.error_cerr("class_window_main::merge_get_letter()", Text::err_UNDEFINED_CHARACTER_REQUESTED, "Z"); 
		
		return 'Z';
	}
	
	return n+'A';
}
