/*****************************************************************************
 *                                                                           *
 * Modul:     gmalloc.h                                                      *
 *            Use dmalloc together with GTK+                                 *
 * Author:    Andreas Tille                                                  *
 * Date:      22.12.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#if !defined(_gmalloc_h_)
#define _gmalloc_h_

#ifdef __DMALLOC__
#ifndef DMALLOC_DISABLE

#undef g_malloc0
#define g_malloc0(count) \
  _calloc_leap(__FILE__, __LINE__, count, 1)
#undef g_free
#define g_free(ptr) \
  _free_leap(__FILE__, __LINE__, ptr)
#undef g_malloc
#define g_malloc(size) \
  _malloc_leap(__FILE__, __LINE__, size)
#undef g_realloc
#define realloc(ptr, size) \
  _realloc_leap(__FILE__, __LINE__, ptr, size)

#undef g_new
#define g_new(type, count) \
  (type *) _malloc_leap(__FILE__, __LINE__, count * sizeof(type))
#undef g_new0
#define g_new0(type, count) \
  (type *) _calloc_leap(__FILE__, __LINE__, count, sizeof(type))
#undef g_renew
#define g_renew(type, ptr, size) \
  (type *) _realloc_leap(__FILE__, __LINE__, ptr, size * sizeof(type))
#undef g_strdup
#define g_strdup(str) \
  _xstrdup_leap(__FILE__, __LINE__, str)
#endif
#include <dmalloc.h>

#endif

#endif
