/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.util.EmptyStackException;

public class SimpleStack {
    private static final int STACK_START_SIZE = 20;
    private static final int STACK_INCREMENT = 5;
    private Object[] stackContents;
    private int topOfStack;

    public SimpleStack() {
        this(20);
    }

    public SimpleStack(int n) {
        this.stackContents = new Object[n];
        this.topOfStack = -1;
    }

    public int size() {
        return this.topOfStack + 1;
    }

    public boolean isEmpty() {
        return this.topOfStack == -1;
    }

    public void push(Object object) {
        this.resizeStack();
        ++this.topOfStack;
        this.stackContents[this.topOfStack] = object;
    }

    public Object peek() throws EmptyStackException {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        return this.stackContents[this.topOfStack];
    }

    public Object pop() {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        Object object = this.stackContents[this.topOfStack];
        this.stackContents[this.topOfStack] = null;
        --this.topOfStack;
        return object;
    }

    public boolean contains(Object object) {
        boolean bl = false;
        int n = this.topOfStack;
        while (--n >= 0) {
            if (this.stackContents[n] == object) {
                bl = true;
                break;
            }
            if (!this.stackContents[n].equals(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void remove(Object object) {
        int n = -1;
        int n2 = this.topOfStack;
        while (--n2 >= 0) {
            if (this.stackContents[n2] == object) {
                n = n2;
                break;
            }
            if (!this.stackContents[n2].equals(object)) continue;
            n = n2;
            break;
        }
        if (n != -1) {
            n2 = this.topOfStack - n;
            if (n2 != 0) {
                System.arraycopy(this.stackContents, n, this.stackContents, n + 1, n2);
            }
            this.stackContents[this.topOfStack] = null;
            --this.topOfStack;
        }
    }

    public void clear() {
        int n = this.topOfStack;
        while (--n >= 0) {
            this.stackContents[n] = null;
        }
        this.topOfStack = -1;
    }

    private final void resizeStack() {
        int n = this.stackContents.length;
        if (this.topOfStack + 1 == n) {
            int n2 = n + 5;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.stackContents, 0, objectArray, 0, n);
            this.stackContents = objectArray;
        }
    }
}

