/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.enveffects;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.nodes.BaseBindableNode;
import org.web3d.vrml.util.FieldValidator;
import org.web3d.vrml.util.URLChecker;

public abstract class BaseBackground
extends BaseBindableNode
implements VRMLBackgroundNodeType,
VRMLMultiExternalNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{5, 30};
    protected static final int FIELD_GROUND_ANGLE = 4;
    protected static final int FIELD_GROUND_COLOR = 5;
    protected static final int FIELD_SKY_ANGLE = 6;
    protected static final int FIELD_SKY_COLOR = 7;
    protected static final int FIELD_BACK_URL = 8;
    protected static final int FIELD_FRONT_URL = 9;
    protected static final int FIELD_LEFT_URL = 10;
    protected static final int FIELD_RIGHT_URL = 11;
    protected static final int FIELD_BOTTOM_URL = 12;
    protected static final int FIELD_TOP_URL = 13;
    protected static final int LAST_BACKGROUND_INDEX = 13;
    protected static final int NUM_FIELDS = 14;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected static final String[] EMPTY_LIST;
    protected static final int BACK = 0;
    protected static final int FRONT = 1;
    protected static final int LEFT = 2;
    protected static final int RIGHT = 3;
    protected static final int TOP = 4;
    protected static final int BOTTOM = 5;
    protected static final int SKY_SPHERE = 6;
    protected static final int GROUND_SPHERE = 7;
    protected static final int NUM_BG_OBJECTS = 8;
    protected static final int[] urlFieldIndexList;
    private static final Class[] requiredImageTypes;
    protected String worldURL;
    protected boolean urlRelativeCheck;
    protected int[] loadState;
    protected String[] loadedUri;
    protected String[] vfBackUrl;
    protected String[] vfFrontUrl;
    protected String[] vfLeftUrl;
    protected String[] vfRightUrl;
    protected String[] vfTopUrl;
    protected String[] vfBottomUrl;
    protected float[] vfGroundAngle;
    protected float[] vfGroundColor;
    protected float[] vfSkyAngle;
    protected float[] vfSkyColor;
    protected int numGroundAngle;
    protected int numGroundColor;
    protected int numSkyAngle;
    protected int numSkyColor;
    private ArrayList urlListeners = new ArrayList(1);
    private ArrayList contentListeners = new ArrayList(1);

    protected BaseBackground() {
        super("Background");
        this.hasChanged = new boolean[14];
        this.loadState = new int[14];
        this.loadedUri = new String[14];
        this.vfBackUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfFrontUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfLeftUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfRightUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfTopUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfBottomUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfSkyColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfGroundAngle = FieldConstants.EMPTY_MFFLOAT;
        this.vfGroundColor = FieldConstants.EMPTY_MFFLOAT;
        this.vfSkyAngle = FieldConstants.EMPTY_MFFLOAT;
        this.numGroundAngle = 0;
        this.numGroundColor = 0;
        this.numSkyAngle = 0;
        this.numSkyColor = 3;
        this.urlRelativeCheck = false;
    }

    protected BaseBackground(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("backUrl");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfBackUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfBackUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("frontUrl");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfFrontUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfFrontUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("leftUrl");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfLeftUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfLeftUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("rightUrl");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfRightUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfRightUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("topUrl");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfTopUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfTopUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("bottomUrl");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfBottomUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfBottomUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("groundAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGroundAngle = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfGroundAngle, 0, vRMLFieldData.numElements);
                this.numGroundAngle = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("groundColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGroundColor = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfGroundColor, 0, vRMLFieldData.numElements * 3);
                this.numGroundColor = vRMLFieldData.numElements * 3;
            }
            n = vRMLNodeType.getFieldIndex("skyAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSkyAngle = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfSkyAngle, 0, vRMLFieldData.numElements);
                this.numSkyAngle = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("skyColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSkyColor = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfSkyColor, 0, vRMLFieldData.numElements * 3);
                this.numSkyColor = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public float getTransparency() {
        return 0.0f;
    }

    public void setTransparency(float f) {
    }

    public int getNumSkyColors() {
        return this.numSkyColor / 3;
    }

    public int getNumGroundColors() {
        return this.numGroundColor / 3;
    }

    public void getSkyValues(float[] fArray, float[] fArray2) {
        System.arraycopy(this.vfSkyColor, 0, fArray, 0, this.numSkyColor);
        if (this.numSkyAngle != 0) {
            System.arraycopy(this.vfSkyAngle, 0, fArray2, 0, this.numSkyAngle);
        }
    }

    public void getGroundValues(float[] fArray, float[] fArray2) {
        System.arraycopy(this.vfGroundColor, 0, fArray, 0, this.numGroundColor);
        if (this.numGroundAngle != 0) {
            System.arraycopy(this.vfGroundAngle, 0, fArray2, 0, this.numGroundAngle);
        }
    }

    public int[] getUrlFieldIndexes() {
        return urlFieldIndexList;
    }

    public String[] getUrl(int n) throws InvalidFieldException {
        String[] stringArray = null;
        switch (n) {
            case 8: {
                stringArray = this.vfBackUrl;
                break;
            }
            case 9: {
                stringArray = this.vfFrontUrl;
                break;
            }
            case 10: {
                stringArray = this.vfLeftUrl;
                break;
            }
            case 11: {
                stringArray = this.vfRightUrl;
                break;
            }
            case 13: {
                stringArray = this.vfTopUrl;
                break;
            }
            case 12: {
                stringArray = this.vfBottomUrl;
                break;
            }
            default: {
                throw new InvalidFieldException("getURL invalid index");
            }
        }
        return stringArray;
    }

    public int getLoadState(int n) {
        return this.loadState[n];
    }

    public void setLoadState(int n, int n2) {
        this.loadState[n] = n2;
        this.fireContentStateChanged(n);
    }

    public boolean checkValidContentType(int n, String string) {
        return string.startsWith("image/");
    }

    public Class[] getPreferredClassTypes(int n) throws InvalidFieldException {
        return requiredImageTypes;
    }

    public void setLoadedURI(int n, String string) {
        this.loadedUri[n] = string;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        this.checkURLs();
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.checkURLs();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 13) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 4;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfBackUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfBackUrl.length;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfFrontUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfFrontUrl.length;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfTopUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfTopUrl.length;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfBottomUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfBottomUrl.length;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfLeftUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfLeftUrl.length;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfRightUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfRightUrl.length;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSkyColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numSkyColor / 3;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSkyAngle;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numSkyAngle;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfGroundColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numGroundColor / 3;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfGroundAngle;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numGroundAngle;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfBackUrl, this.vfBackUrl.length);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfFrontUrl, this.vfFrontUrl.length);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfLeftUrl, this.vfLeftUrl.length);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfRightUrl, this.vfRightUrl.length);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfTopUrl, this.vfTopUrl.length);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfBottomUrl, this.vfBottomUrl.length);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfGroundAngle, this.numGroundAngle);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfGroundColor, this.numGroundColor);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfSkyAngle, this.numSkyAngle);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfSkyColor, this.numSkyColor);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (n2 > this.vfGroundAngle.length) {
                    this.vfGroundAngle = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfGroundAngle, 0, n2);
                this.numGroundAngle = n2;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 5: {
                FieldValidator.checkColorArray("Background.GroundColor", fArray);
                if (n2 > this.vfGroundColor.length) {
                    this.vfGroundColor = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfGroundColor, 0, n2);
                this.numGroundColor = n2;
                if (this.inSetup) break;
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            case 6: {
                if (fArray.length > this.vfSkyAngle.length) {
                    this.vfSkyAngle = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfSkyAngle, 0, n2);
                this.numSkyAngle = n2;
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            case 7: {
                FieldValidator.checkColorArray("Background.SkyColor", fArray);
                if (n2 > this.vfSkyColor.length) {
                    this.vfSkyColor = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfSkyColor, 0, n2);
                this.numSkyColor = n2;
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                if (this.vfBackUrl.length != n2) {
                    this.vfBackUrl = new String[n2];
                }
                if (n2 != 0) {
                    System.arraycopy(stringArray, 0, this.vfBackUrl, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            case 9: {
                if (this.vfFrontUrl.length != n2) {
                    this.vfFrontUrl = new String[n2];
                }
                if (n2 != 0) {
                    System.arraycopy(stringArray, 0, this.vfFrontUrl, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                break;
            }
            case 10: {
                if (this.vfLeftUrl.length != n2) {
                    this.vfLeftUrl = new String[n2];
                }
                if (n2 != 0) {
                    System.arraycopy(stringArray, 0, this.vfLeftUrl, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
                break;
            }
            case 11: {
                if (this.vfRightUrl.length != n2) {
                    this.vfRightUrl = new String[n2];
                }
                if (n2 != 0) {
                    System.arraycopy(stringArray, 0, this.vfRightUrl, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            case 13: {
                if (this.vfTopUrl.length != n2) {
                    this.vfTopUrl = new String[n2];
                }
                if (n2 != 0) {
                    System.arraycopy(stringArray, 0, this.vfTopUrl, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[13] = true;
                this.fireFieldChanged(13);
                break;
            }
            case 12: {
                if (this.vfBottomUrl.length != n2) {
                    this.vfBottomUrl = new String[n2];
                }
                if (n2 != 0) {
                    System.arraycopy(stringArray, 0, this.vfBottomUrl, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[12] = true;
                this.fireFieldChanged(12);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    private void checkURLs() {
        URLChecker.checkURLsInPlace(this.worldURL, this.vfBackUrl, false);
        URLChecker.checkURLsInPlace(this.worldURL, this.vfFrontUrl, false);
        URLChecker.checkURLsInPlace(this.worldURL, this.vfLeftUrl, false);
        URLChecker.checkURLsInPlace(this.worldURL, this.vfRightUrl, false);
        URLChecker.checkURLsInPlace(this.worldURL, this.vfTopUrl, false);
        URLChecker.checkURLsInPlace(this.worldURL, this.vfBottomUrl, false);
    }

    protected void fireUrlChanged(int n) {
        int n2 = this.urlListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged(this, n);
        }
    }

    protected void fireContentStateChanged(int n) {
        int n2 = this.contentListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged(this, n, this.loadState[n]);
        }
    }

    static {
        EMPTY_LIST = new String[0];
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[14];
        fieldMap = new HashMap(14);
        BaseBackground.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseBackground.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_bind");
        BaseBackground.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isBound");
        BaseBackground.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFTime", "bindTime");
        BaseBackground.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFFloat", "groundAngle");
        BaseBackground.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFColor", "groundColor");
        BaseBackground.fieldDecl[6] = new VRMLFieldDeclaration(3, "MFFloat", "skyAngle");
        BaseBackground.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFColor", "skyColor");
        BaseBackground.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "backUrl");
        BaseBackground.fieldDecl[9] = new VRMLFieldDeclaration(3, "MFString", "frontUrl");
        BaseBackground.fieldDecl[10] = new VRMLFieldDeclaration(3, "MFString", "leftUrl");
        BaseBackground.fieldDecl[11] = new VRMLFieldDeclaration(3, "MFString", "rightUrl");
        BaseBackground.fieldDecl[13] = new VRMLFieldDeclaration(3, "MFString", "topUrl");
        BaseBackground.fieldDecl[12] = new VRMLFieldDeclaration(3, "MFString", "bottomUrl");
        fieldMap.put("set_bind", new Integer(1));
        fieldMap.put("isBound", new Integer(3));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("bindTime", n);
        fieldMap.put("bindTime_changed", n);
        n = new Integer(8);
        fieldMap.put("backUrl", n);
        fieldMap.put("set_backUrl", n);
        fieldMap.put("backUrl_changed", n);
        n = new Integer(9);
        fieldMap.put("frontUrl", n);
        fieldMap.put("set_frontUrl", n);
        fieldMap.put("frontUrl_changed", n);
        n = new Integer(10);
        fieldMap.put("leftUrl", n);
        fieldMap.put("set_leftUrl", n);
        fieldMap.put("leftUrl_changed", n);
        n = new Integer(11);
        fieldMap.put("rightUrl", n);
        fieldMap.put("set_rightUrl", n);
        fieldMap.put("rightUrl_changed", n);
        n = new Integer(13);
        fieldMap.put("topUrl", n);
        fieldMap.put("set_topUrl", n);
        fieldMap.put("topUrl_changed", n);
        n = new Integer(12);
        fieldMap.put("bottomUrl", n);
        fieldMap.put("set_bottomUrl", n);
        fieldMap.put("bottomUrl_changed", n);
        n = new Integer(4);
        fieldMap.put("groundAngle", n);
        fieldMap.put("set_groundAngle", n);
        fieldMap.put("groundAngle_changed", n);
        n = new Integer(5);
        fieldMap.put("groundColor", n);
        fieldMap.put("set_groundColor", n);
        fieldMap.put("groundColor_changed", n);
        n = new Integer(6);
        fieldMap.put("skyAngle", n);
        fieldMap.put("set_skyAngle", n);
        fieldMap.put("skyAngle_changed", n);
        n = new Integer(7);
        fieldMap.put("skyColor", n);
        fieldMap.put("set_skyColor", n);
        fieldMap.put("skyColor_changed", n);
        urlFieldIndexList = new int[6];
        BaseBackground.urlFieldIndexList[0] = 8;
        BaseBackground.urlFieldIndexList[1] = 9;
        BaseBackground.urlFieldIndexList[2] = 10;
        BaseBackground.urlFieldIndexList[3] = 11;
        BaseBackground.urlFieldIndexList[4] = 13;
        BaseBackground.urlFieldIndexList[5] = 12;
        requiredImageTypes = null;
    }
}

