/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.util.interpolator.CoordinateInterpolator;

public class TestCoordinateInterpolator
extends TestCase {
    private static float[] keys = new float[]{0.1f, 0.4f, 5.0f};
    private static float[][] values = new float[][]{{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f}, {1.0f, 5.0f, 2.0f, 5.0f, 5.0f, 5.0f}};
    private CoordinateInterpolator interpolator;

    public TestCoordinateInterpolator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestCoordinateInterpolator("testInvalidInsert"));
        testSuite.addTest((Test)new TestCoordinateInterpolator("testCreateFloat"));
        testSuite.addTest((Test)new TestCoordinateInterpolator("testValueInsertFloat"));
        testSuite.addTest((Test)new TestCoordinateInterpolator("testKeyGenFloat"));
        testSuite.addTest((Test)new TestCoordinateInterpolator("testClamping"));
        return testSuite;
    }

    public void setUp() {
        TestCoordinateInterpolator.assertEquals((String)"Keys and values arrays are not the same size", (int)keys.length, (int)values.length);
        this.interpolator = new CoordinateInterpolator();
    }

    public void testInvalidInsert() {
        float[] fArray;
        try {
            this.interpolator.addKeyFrame(0.0f, null);
            TestCoordinateInterpolator.fail((String)"Accepted null key");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fArray = new float[]{};
            this.interpolator.addKeyFrame(0.0f, fArray);
            TestCoordinateInterpolator.fail((String)"Accepted value of zero length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fArray = new float[]{0.0f, 1.0f};
            this.interpolator.addKeyFrame(0.0f, fArray);
            TestCoordinateInterpolator.fail((String)"Accepted value length < 3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fArray = new float[]{0.0f, 1.0f, 3.0f, 5.0f};
            this.interpolator.addKeyFrame(0.0f, fArray);
            TestCoordinateInterpolator.fail((String)"Accepted value length not divisible 3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateFloat() {
        int n;
        int n2 = keys.length;
        for (n = 0; n < n2; ++n) {
            this.interpolator.addKeyFrame(keys[n], values[n]);
        }
        for (n = 0; n < n2; ++n) {
            float[] fArray = this.interpolator.floatValue(keys[n]);
            for (int i = 0; i < fArray.length; ++i) {
                TestCoordinateInterpolator.assertEquals((String)("key " + n + " coord " + i + " not same"), (float)values[n][i], (float)fArray[i], (float)0.0f);
            }
        }
    }

    public void testValueInsertFloat() {
        int n = keys.length;
        TestCoordinateInterpolator.assertTrue((String)"Not enough keys ( < 3) to do this test", (n > 2 ? 1 : 0) != 0);
        this.interpolator.addKeyFrame(keys[0], values[0]);
        this.interpolator.addKeyFrame(keys[2], values[2]);
        this.interpolator.addKeyFrame(keys[1], values[1]);
        for (int i = 0; i < n; ++i) {
            float[] fArray = this.interpolator.floatValue(keys[i]);
            for (int j = 0; j < fArray.length; ++j) {
                TestCoordinateInterpolator.assertEquals((String)("key " + i + " coord " + j + " not same"), (double)values[i][j], (double)fArray[j], (double)0.0);
            }
        }
    }

    public void testKeyGenFloat() {
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            this.interpolator.addKeyFrame(keys[i], values[i]);
        }
        float f = keys[0] + (keys[1] - keys[0]) / 2.0f;
        float f2 = values[0][0] + (values[1][0] - values[0][0]) / 2.0f;
        float f3 = values[0][0] + (values[1][1] - values[0][1]) / 2.0f;
        float f4 = values[0][0] + (values[1][2] - values[0][2]) / 2.0f;
        float[] fArray = this.interpolator.floatValue(f);
        TestCoordinateInterpolator.assertEquals((String)"1st X coord not same", (double)f2, (double)fArray[0], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"1st Y coord not same", (double)f3, (double)fArray[1], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"1st Z coord not same", (double)f4, (double)fArray[2], (double)0.0);
        f = keys[1] + (keys[2] - keys[1]) / 2.0f;
        f2 = values[1][0] + (values[2][0] - values[1][0]) / 2.0f;
        f3 = values[1][1] + (values[2][1] - values[1][1]) / 2.0f;
        f4 = values[1][2] + (values[2][2] - values[1][2]) / 2.0f;
        fArray = this.interpolator.floatValue(f);
        TestCoordinateInterpolator.assertEquals((String)"2nd X coord not same", (double)f2, (double)fArray[0], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"2nd Y coord not same", (double)f3, (double)fArray[1], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"2nd Z coord not same", (double)f4, (double)fArray[2], (double)0.0);
    }

    public void testClamping() {
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            this.interpolator.addKeyFrame(keys[i], values[i]);
        }
        float f = keys[0] - 1.0f;
        float[] fArray = this.interpolator.floatValue(f);
        TestCoordinateInterpolator.assertEquals((String)"Min X coord not same", (double)values[0][0], (double)fArray[0], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"Min Y coord not same", (double)values[0][1], (double)fArray[1], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"Min Z coord not same", (double)values[0][2], (double)fArray[2], (double)0.0);
        f = keys[--n] + 1.0f;
        fArray = this.interpolator.floatValue(f);
        TestCoordinateInterpolator.assertEquals((String)"Max X coord not same", (double)values[n][0], (double)fArray[0], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"Max Y coord not same", (double)values[n][1], (double)fArray[1], (double)0.0);
        TestCoordinateInterpolator.assertEquals((String)"Max Z coord not same", (double)values[n][2], (double)fArray[2], (double)0.0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestCoordinateInterpolator.suite());
    }
}

