/*
**  Part.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Foundation/Foundation.h>

@interface Part : NSObject <NSCoding>
{
  NSString *contentType;
  NSString *contentID;
  NSString *contentDescription;
  NSString *contentDisposition;
  NSString *filename;

  NSObject *content;

  int contentTransferEncoding;
  int format;
  int line_length;
  int size;

  NSData *boundary;
  NSString *charset;
}

- (id) initWithData: (NSData *) theData;
- (void) dealloc;

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// access / mutation methods
//

//
// Content-Type: TEXT/PLAIN; CHARSET=iso-8859-1
//
- (NSString *) contentType;                           
- (void) setContentType: (NSString*) theContentType;

//
// Content-ID: <xyx.1234.abc@efg.com>
//
- (NSString *) contentID;                         
- (void) setContentID: (NSString *) theContentID;
 
//
// Content-Description: abcdef...
//
- (NSString *) contentDescription;                                   
- (void) setContentDescription: (NSString *) theContentDescription;

//
// Content-Disposition: attachment; filename="jdbctunnel.jar"
//
- (NSString *) contentDisposition;                                   
- (void) setContentDisposition: (NSString *) theContentDisposition; 

//
// Content-Transfer-Encoding: 0 = 7bit, 1 = quoted-printable and 2 = base64
//
- (int) contentTransferEncoding;                         
- (void) setContentTransferEncoding: (int) theEncoding;

//
// Return the filename of the content (if possible, nil otherwise)
//
- (NSString *) filename;                            
- (void) setFilename: (NSString *) theFilename;     

//
// Return the format of the content
//
- (int) format;                                     
- (void) setFormat: (int) theFormat;                
- (int) lineLength;
- (void) setLineLength: (int) theLineLength;

- (BOOL) isMimeType: (NSString *) primaryType : (NSString *) subType;

//
// Return the content of the part. Could be a NSString, a NSData, etc
//
- (NSObject *) content;                      
- (void) setContent: (NSObject* ) theContent;

- (long) size;
- (void) setSize: (long) theSize;


- (NSData *) dataUsingSendingMode : (int) theMode;

- (NSData *) boundary;
- (void) setBoundary: (NSData *) theBoundary;

- (NSString *) charset;
- (void) setCharset: (NSString *) theCharset;

@end

