/*
**  IMAPMessage.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/IMAPMessage.h>

#import <Pantomime/Constants.h>
#import <Pantomime/IMAPFolder.h>

@implementation IMAPMessage 

//
// This method is called to initialize the message if it wasn't.
// If we set it to NO and we HAD a content, we release the content.
//
- (void) setInitialized: (BOOL) aBOOL
{
  [super setInitialized: aBOOL];

  if ( aBOOL )
    {
      NSData *aData;
      IMAPFolder *aFolder;

      aFolder = (IMAPFolder *)[self folder];

      aData = [aFolder prefetchMessageBodyWithUID: [self messageNumber]];
      
      if ( aData )
	{
	  [self setContentFromRawSource: aData];
	}
      else
	{
	  NSLog(@"Unable to initialize the Message.");
	}
    }
  else
    {
      TEST_RELEASE(content);
      content = nil;
    }
}


//
// IMAP specific implementation of the rawSource method.
//
- (NSData *) rawSource
{
  IMAPFolder *aFolder;

  aFolder = (IMAPFolder *)[self folder];

  return [aFolder prefetchMessageWithUID: [self messageNumber]];
}



@end
