/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Pan - A Newsreader for X
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __FILTER_THREAD_H__
#define __FILTER_THREAD_H__

#include <pan/filters/filter.h>

extern const gchar * FILTER_THREAD_CLASS_ID;
#define FILTER_THREAD(a) ((FilterThread*)filter_cast((Filter*)a,FILTER_THREAD_CLASS_ID))

typedef struct _FilterThread FilterThread;

typedef enum
{
	FILTER_THREAD_WATCHED,
	FILTER_THREAD_IGNORED,
	FILTER_THREAD_NOTHING
}
FilterThreadState;

struct _FilterThread
{
	/* Parent */
	Filter parent;

	/* Fields */
	FilterThreadState state;
};

/***
****  PUBLIC
***/

Filter*      filter_thread_new           (void);

void         filter_thread_set_state     (FilterThread        * filter_thread,
                                          FilterThreadState     state);

#endif
