#!/usr/bin/perl -w
# creates the release, assuming build application

sub evaluateArguments();


evaluateArguments();
print "Please enter a version string: ";
my $version = <STDIN>;
chomp($version);

if ($debian)
{
	print "Did you remember to run dch -v $version and commit the changes? (y/n)?\n";
	my $decide = <STDIN>;
	if ( $decide =~ /n/ )
	{
		system("dch -v $version");
		system("svn commit debian/changelog");
	}
}

my $headmodule = "packagesearch";	# toplevel module
my $projectname = "packagesearch";	# the sourceforge name of the project
my $releasename = "packagesearch";	# the base name the release file 


# directory where the binary release is located
my $binReleaseDir="bin_release/$releasename-v$version\/";
print "$binReleaseDir\n";

mkdir("release");
if ($binary)
{
	mkdir("release/bin_release");
	mkdir("release/$binReleaseDir");
}
chomp($date =`date +\%Y-\%m-\%d`);	# get the current date
my $bin_filename = "$releasename-v$version-linux-i386-binary.tar.bz2";
my $src_filename = "$releasename-v$version-$date-src.tar.bz2";

print "Changing directory to release\n";
chdir("release");
if ($source)
{
	print "Getting the svn version\n";
	(system("svn export https://packagesearch.svn.sourceforge.net/svnroot/packagesearch/trunk/packagesearch")==0)
		|| die("Could not get svn version.\n");
	print "creating source tarball\n";
	(system("tar cjf $src_filename $headmodule\/\n")==0) || die("could not create archive.\n");
	print "source tarball $src_filename created\n";
}

if ($debian)
{
	`mv $headmodule $headmodule-$version`;
	print "creating debian package\n";
	chdir("$headmodule-$version");
	(system("dpkg-buildpackage -rfakeroot")==0) || die("could not create archive.\n");
	chdir("..");
	# `lintian -i ${headmodule}_${version}-*_i386.changes`;	# we don't know the revision here, so try a star
	print "Press any key to continue";
	my $dummy = <STDIN>;
	`mv $headmodule-$version $headmodule`;
}

#create the binary release
if ($binary)
{
	chdir($headmodule);
	print "please change to release if you want to\n";
	$test=`kwrite src/packagesearch.pro`;	# don't use the system() function to ensure the order of execution
	print "creating $releasename\n";
	chdir("src");
	(system("qmake packagesearch.pro && make")==0)  || die("build script failed");
	chdir("../../");
	print "copying files for release\n";
	# copy head executables
	$test=`cp $headmodule/src/$releasename $binReleaseDir`;
	#copy data dir
	mkdir("${binReleaseDir}doc");
	mkdir("${binReleaseDir}icons");
	`cp $headmodule/icons/packagesearch.png ${binReleaseDir}icons/`;
	`cp $headmodule/doc/{index.html,COPYING.txt} ${binReleaseDir}doc/`;
	`cp $headmodule/{README,AUTHORS,COPYING} ${binReleaseDir}/`;

	chdir("bin_release");
	print "creating binary release\n";
	(system("tar cjvf ../$bin_filename $releasename-v$version")==0) || die("could not create archive.") ;
	print "binary tarball $bin_filename created\n";
}


sub evaluateArguments()
{
	if (@ARGV==0)	# no argument
	{
		print "usage: make_release.pl [source] [binary] [debian]\n";
		exit;
	}
	$binary = 0;
	$source = 0;
	foreach(@ARGV)
	{
		if ($_ eq "debian")
		{
			$debian = 1;
		}
		elsif ($_ eq "source")
		{
			$source = 1;
		}
		elsif ($_ eq "binary")
		{
			$binary = 1;
		}
		else	# not one of the keywords
		{
			print "usage: make_release.pl [source] [binary] [debian]\n";
			exit;
		}
	}
}
