/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

/** @brief Filters the view by the given pattern. 
  *
  * Called whenever the text in the filterinput changed. */
void FilenameView::onFilterChanged( const QString & pattern )
{
 _filterTextEmpty = pattern.isEmpty();
 updateView();
}


/** Clears the content of the widget excluding the filter*/
void FilenameView::clear()
{
 _errorMessage = "";
 _entries.clear();
 _pFilenameView->clear();
}

/** @brief Sets the search pattern for the filter. 
  * 
  * The view will be updated accordingly. */
void FilenameView::setFilterText( const QString & pattern )
{
 _pFilterInput->setText(pattern);
}

/** Adds an entry to the widget. */
void FilenameView::addEntry( const QString & entry )
{
 _entries.push_back(entry);
 insertItem(entry);
}


void FilenameView::init()
{
 _filterTextEmpty = true;
 _pFilenameView->header()->hide();
  _pErrorDisplay->setShown(false);
 connect(_pShowButton, SIGNAL(clicked()), SIGNAL(showRequested()));
}

/** Shows the entries which shall be shown according to the filter currently active. */
void FilenameView::updateView()
{
 _pFilenameView->clear();
 if (_errorMessage.isEmpty()) // if no error was indicated
 {
  _pFilenameView->setShown(true);
  _pErrorDisplay->setShown(false);

  for ( QStringList::iterator it = _entries.begin(); it != _entries.end(); ++it)
  {
  insertItem(*it);
  }
 }
 else
 {
 _pErrorDisplay->setText(_errorMessage);
 _pFilenameView->setShown(false);
 _pErrorDisplay->setShown(true);
 }
}

/** @brief Call this function if you want to indicate an error.
  * 
  * The error message will be shown and not affected by the filter.
  * The error state will cleaned at next call of the clean() function. */
void FilenameView::setErrorMessage( const QString & errorMessage )
{
 /** The error message holds the error state. If it is empty no error has occured. */
 _errorMessage = errorMessage;
 updateView();
}

/**  @brief This adds an item to the filename view but only if it matches the filter. */
void FilenameView::insertItem( const QString & entry )
{
 if ( _filterTextEmpty || entry.contains(_pFilterInput->text()) )
 {
  QListViewItem* pItem = new QListViewItem(_pFilenameView, entry);
  // allow to copy the item
  pItem->setRenameEnabled(0, true);
 }
  _pFilenameView->setShown(true);
  _pErrorDisplay->setShown(false);
}
