#ifndef __RELATEDPLUGIN_H_2004_06_23
#define __RELATEDPLUGIN_H_2004_06_23

#include <singlehandlemaker.h>

#include <OpSet.h>
#include <TagCollection.h>
#include <InputMerger.h>

#include <searchplugin.h>
#include <debtagsplugincontainer.h>

class QTimer;


class RelatedInput;
class RelatedFeedbackWidget;


namespace NPlugin
{

class RelatedPlugin : public SearchPlugin 
{
	Q_OBJECT
public:
	RelatedPlugin(const DebtagsPluginContainer& container);
	~RelatedPlugin();
	/** @name Plugin Interface
	  * 
	  * Implementation of the PluginInterface
	  */
	//@{
	virtual void init(IProvider* pProvider);
	/// @todo not yet implemented
	virtual void setEnabled(bool enabled)	{};
	/// @todo not yet implemented
	virtual void setVisible(bool visible)	{};
	virtual QString title() const;
	virtual QString briefDescription() const;
	virtual QString description() const;
	//@}
	///@todo try to remove malformed descriptions
	/** @name SearchPlugin interface
	  * 
	  * Implementation of the SearchPlugin interface
	  */
	//@{
	virtual uint searchPriority() const	{ return 10; }
	/** @brief Returns a widget where you can select the debtags you want to in- and exclude. */
	virtual QWidget* inputWidget() const;
	/** @brief Returns &quot;Debtags&quot;.  */
	virtual QString inputWidgetTitle() const;
	virtual QWidget* shortInputAndFeedbackWidget() const;
	virtual void clearSearch();
	virtual bool usesFilterTechnique() const	{ return false; };
	virtual const Tagcoll::OpSet<int>& searchResult() const;
	/** This plugin does not use the filter technique. */
	virtual bool filterPackage (int packageID) const	{ return true; };
	virtual bool isInactive() const	{ return _isInactive; };
	//@}
	/** @brief This can be used to notify the plugin that the debtags data in the 
	  * plugin container (i.e. the tag collection and the vocabulary) has changed. 
	  *
	  * If the tag collection is 0 the plugin will disable itself. */
	void debtagsDataChanged();
protected slots:
	/** @brief Called whenever the user requests to clear the search. */
	void onClearSearch()	{ clearSearch(); };
	/** @brief This is called everytime the search changes.
	  *
	  * It might emit the searchChanged() signal. */
	void evaluateSearch();
	/** @brief This is called whenever the text of the widget where to insert the 
	  * package to be matched changes. 
	  *
	  * Is only needed because the QComboBox::setCurrentText("") function does not 
	  * trigger a activated() signal.
	  */
	void onInputTextChanged(const QString& text);
	/** This enables/ disables the visible widgets. */
	void setWidgetsEnabled(bool enabled);
private:
	/** The container which holds this plugin. */
	const DebtagsPluginContainer& _container;
	Tagcoll::HandleMaker<string>* _pHandleMaker;
	/** @brief Holds the result of the search currently active. */
 	Tagcoll::OpSet<int> _searchResult;
	/** @brief Holds a pointer to the Plugin Manager which manages this plugin. */
	IProvider* _pProvider;
	/** @brief Holds a pointer to the main window this plugin belongs to. */
	QMainWindow* _pMainWindow;
	/** @brief Holds a pointer to the widget used for inputting the related search. */
	RelatedInput* _pRelatedInput;
	/** @brief Holds a pointer to the widget used for displaying the currenly active search.
	  *
	  * This widget will be hidden if no search was active i.e. if #_isInactive is true. */
	RelatedFeedbackWidget* _pRelatedFeedbackWidget;
	/** This holds is the search is currently inactive. */
	bool _isInactive;
	/** This is the delay time in ms the delay timer waits for another input. */
	uint _delayTime;
	/** @brief This holds the tag collection. 
	  *
	  * Every item (package) appears only ones in the collection. */
	Tagcoll::TagCollection<int, string>* _pColl;
};


}	// namespace NPlugin

#endif //	__RELATEDPLUGIN_H_2004_06_23

