#include "baseplugincontainer.h"

#include <iostream>

#include "plugin.h"
#include "iprovider.h"
#include "ipluginfactory.h"

#include "helpers.h"

namespace NPlugin
{

BasePluginContainer::~BasePluginContainer()
{
	for (PluginMap::iterator it = _plugins.begin(); it != _plugins.end(); ++it)
	{
		if (it->second != 0)
			_pluginInformer.informRemovePlugin(it->second);
		delete it->second;
	}
}

bool BasePluginContainer::init(IProvider* pProvider, IPluginFactory* pFactory)
{
	_pFactory = pFactory;
	_pProvider = pProvider;
	return true;
}

void BasePluginContainer::addPlugin(const string& name)
{
	_plugins[name] = 0;
	_pluginNames.push_back(name);
}


Plugin* BasePluginContainer::requestPlugin(const string& name)
{
	if (_pProvider==0 || _pFactory==0)
	{
		cerr << "Programming error: Requesting plugin while (_pProvider==0 || _pFactory==0) "
			<< " please file a bug report." <<endl;
		return 0;
	}
	// find the entry for the plugin with this name
	PluginMap::iterator it = _plugins.find(name);
	if (it == _plugins.end())
		return 0;
	Plugin* pPlugin = it->second;
	if (!pPlugin)
	{
		pPlugin = _pFactory->createPlugin(name);
		it->second = pPlugin;
	}
	else
		return pPlugin;
	if (pPlugin)
	{
		pPlugin->init(_pProvider);
		_pluginInformer.informAddPlugin(pPlugin);
	}
	return pPlugin;
}

void BasePluginContainer::releasePlugin(Plugin* pPlugin)
{
	// find the plugin in the _plugins map
	PluginMap::iterator it = _plugins.begin();
	while (it != _plugins.end() && it->second != pPlugin)
		++it;
	if (it == _plugins.end())
		return;
	_pluginInformer.informRemovePlugin(pPlugin);
	it->second = 0;
	delete pPlugin;
}

vector<Plugin*> BasePluginContainer::getLoadedPlugins()
{
	vector<Plugin*> result;
	for (PluginMap::iterator it = _plugins.begin(); it != _plugins.end(); ++it)
	{
		if (it->second != 0)
			result.push_back(it->second);
	}
	return result;
}

}	// namespace NPlugin
