//
// C++ Implementation: tagselectionwidget
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "tagselectionwidget.h"


namespace NWidgets {

TagSelectionWidget::TagSelectionWidget(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	QString qName(name);
	
	QBoxLayout* pLayout=new QVBoxLayout(this);
	QBoxLayout* pFilterLayout = new QHBoxLayout(pLayout);

	// create the part to enter a filter expression
	pFilterLayout->addWidget(new QLabel(tr("Tag Filter"), this));
	_pFilterInput = new QLineEdit(this, qName+"FilterInput");
	QToolTip::add(_pFilterInput, tr("Filters tags by expression"));
	QWhatsThis::add(_pFilterInput, tr("Filters the tag list by the given Expression. Only the tags "
		"which match the expression entered will be shown.")
	);
	pFilterLayout->addWidget(_pFilterInput);

	_pTagSelectionList = new TagSelectionListView(this, qName+"Selection");
	QToolTip::add(_pTagSelectionList, "Select tags to search for here");
	QWhatsThis::add(_pTagSelectionList, 
		tr("Use this list to select the tags to search for.<br>"
			"The tags a are listed beneath the facets they belong to. It is also possible to select "
			"the facets itself, meaning to search for all tags beneath the facet (for more detailed "
			"information choose Help -> Contents from the menu)."));
	pLayout->addWidget(_pTagSelectionList);
	connect( _pFilterInput, SIGNAL(textChanged(const QString&)), SLOT(onFilterTextChanged(const QString&)) );
}


TagSelectionWidget::~TagSelectionWidget()
{
}


};
