#ifndef __DEBTAGSPLUGINCONTAINER_H_2004_06_23
#define __DEBTAGSPLUGINCONTAINER_H_2004_06_23

#include <string>

#include <qobject.h>
#include <qstring.h>

#include <HandleMaker.h>
#include <TagSet.h>

#include <baseplugincontainer.h>

namespace Tagcoll
{
	// try to minimize the compile dependencies
	template <class T, class Tag>	
	class InputMerger;
	
	template <class T1, class T2>
	class TagCollection;
	
	template <class T1, class T2>
	class TagcollConsumer;
}

using namespace std;

namespace NApplication
{
	class RunCommand;
}

class DebtagsSettingsWidget;

namespace NPlugin
{

class DebtagsPlugin;
class RelatedPlugin;

/** @brief This class provides plugins using the debtags system.
  * 
  * It manages the shared data and offers the possibility to update the debtags database.
  *
  * @author Benjamin Mesing
  */
class DebtagsPluginContainer : public QObject, public BasePluginContainer 
{
	Q_OBJECT
	/** @brief This holds a list of the names of all the plugins offered by this 
	  * plugin container. 
	  *
	  * @see offeredPlugins() 
	  */
	vector<QString> _offeredPlugins;
	/** @brief This holds if the debtags operations are currently enabled. 
	  * 
	  * This will be set to false if the reading of the tag database failed. 
	  */
	bool _debtagsEnabled;
	Tagcoll::HandleMaker<string>* _pHandleMaker;
	/** @brief Action which represents the debtags update option.
	  *
	  * It is connected to onDebtagsUpdate(). 
	  */
	QAction* _pDebtagsUpdateAction;
	/** Holds the debtags plugin created. */
	DebtagsPlugin* _pDebtagsPlugin;
	/** Holds the related plugin created. */
	RelatedPlugin* _pRelatedPlugin;
	/** This pointer is used to run the <tt>debtags update</tt> command. */
	NApplication::RunCommand* _pCommand;
	/** @brief This holds the facets which are currently in use.
	  *
	  * It gets them from the Debtags::Vocabulary and shows only those which
	  * are not hidden.
	  * @see #_hiddenFacets
	  */
	Tagcoll::FacetSet _facets;
	/** @brief This holds the names of the facets that shall not be shown.
	  *
	  * This can be used to reduce the complexity for the user. 
	  */
	set<string> _hiddenFacets;
	/** @brief This holds the tag collection. 
	  *
	  * If no collection is loaded it is set to 0.
	  * Every item (package) appears only ones in the collection. 
	  */
	Tagcoll::TagCollection<int, string>* _pCollection;
	/** @brief This holds a pointer to the settings widget currently active.
	  * 
	  * This pointer must not be deleted and should only be used in applySettings(). 
	  */
	DebtagsSettingsWidget* _pSettingsWidget;
public:
	/** Empty Constructor  */
	DebtagsPluginContainer();
	~DebtagsPluginContainer();
	/** @name PluginContainer Interface
	  *
	  * These functions implement the PluginContainer interface.
	  */
	//@{
	virtual bool init(IProvider* pProvider);
	/** @returns "debtagsplugin" */
	virtual string name() const {	return "debtagsplugin"; };
	// documented in base class
	virtual QString title() const	{ return tr("Debtags Plugins"); };
	/** @brief This returns a list with one entry which is the "Debtags Update" entry
	  *
	  * The QString specifies the menu the action should be added to, the action is
	  * a QAction which is connected to the operation to perform.\n
	  * The default implementation returns an empty vector.
	  */
	vector< pair<QString, QAction*> > actions();
	// documented in base class
	virtual QWidget* getSettingsWidget(QWidget* pParent);
	// documented in base class
	virtual void applySettings();
	/** @brief Loads the settings from the element node.
	  *
	  * Does nothing in its default implementation. 
	  * @param source the element where the information is stored
	  */
	virtual void loadSettings(const QDomElement source);
	/** @brief Save the settings from this plugin container into the given XML tree
	  * 
	  * Does nothing in its default implementation. 
	  * @param outData XML Document which owns parent
	  * @param parent the parent under which to add the settings
	  */
	virtual void saveSettings(NXml::XmlData& outData, QDomElement parent) const;
	//@}
	/** @brief Returns the #_debtagsEnabled property. */
	bool debtagsEnabled()	{ return _debtagsEnabled; };
	/** @brief Returns the #_facets property. */
	const Tagcoll::FacetSet& facets() const	{ return _facets; }
	/** @brief Returns the #_pCollection property. */
	Tagcoll::TagCollection<int, string>* collection() const	{ return _pCollection; }
protected slots:
	/** @brief Launches the debtags update command. */
	void onDebtagsUpdate();
	/** @brief This function will be called if the update finished. 
	  *
	  * It will update the debtags database used. 
	  */
	void onDebtagsUpdateFinished();
protected:
	/** @brief This sets the debtags operations to be enabled/ disabled 
	  *
	  * If set to false all widgets will be disabled, else they will be enabled.
	  * @see #_debtagsEnabled 
	  */
	void setDebtagsEnabled(bool enabled);
	/** @brief Loads the latest debtags database and informs the plugins about the changing of the
	  * database.
	  * 
	  * Behaves sound when loading fails (informing plugins about set to zero).
	  */
	void updateDebtags();
	/** @brief This loads the vocabulary data and filling the #_facets set. 
	  *
	  * The contained plugins will be informed that the debtags data has changed.
	  * If loading fails #_facets will be left empty. 
	  * @param informPlugins if true the plugins will be informed about changing of
	  * the debtags data, set to false if they will be informed on another way
	  */
	void updateVocabulary(bool informPlugins = true);
};

}	// namespace NPlugin

#endif //	__DEBTAGSPLUGINCONTAINER_H_2004_06_23

