#
# Copyright (C) 2008 Aurelien Lefebvre <alkh@mandriva.org>
#
# Licensed under the GNU General Public License Version 2
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#

package perl_packagekit::enums;

use Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw(
  FILTER_BASENAME 
  FILTER_DEVELOPMENT 
  FILTER_FREE 
  FILTER_GUI 
  FILTER_INSTALLED 
  FILTER_NEWEST 
  FILTER_NONE 
  FILTER_NOT_BASENAME 
  FILTER_NOT_DEVELOPMENT 
  FILTER_NOT_FREE 
  FILTER_NOT_GUI 
  FILTER_NOT_INSTALLED 
  FILTER_NOT_NEWEST 
  FILTER_NOT_SUPPORTED 
  FILTER_NOT_VISIBLE 
  FILTER_SUPPORTED 
  FILTER_UNKNOWN 
  FILTER_VISIBLE
  FILTER_DOWNLOADED,
  FILTER_NOT_DOWNLOADED,
  FILTER_ENUM_APPLICATION
  FILTER_ENUM_NOT_APPLICATION
  
  GROUP_ACCESSIBILITY 
  GROUP_ACCESSORIES 
  GROUP_ADMIN_TOOLS 
  GROUP_COMMUNICATION 
  GROUP_DESKTOP_GNOME 
  GROUP_DESKTOP_KDE 
  GROUP_DESKTOP_OTHER 
  GROUP_DESKTOP_XFCE 
  GROUP_EDUCATION 
  GROUP_FONTS 
  GROUP_GAMES 
  GROUP_GRAPHICS 
  GROUP_INTERNET 
  GROUP_LEGACY 
  GROUP_LOCALIZATION 
  GROUP_MAPS 
  GROUP_MULTIMEDIA 
  GROUP_NETWORK 
  GROUP_OFFICE 
  GROUP_OTHER 
  GROUP_POWER_MANAGEMENT 
  GROUP_PROGRAMMING 
  GROUP_PUBLISHING 
  GROUP_REPOS 
  GROUP_SECURITY 
  GROUP_SERVERS 
  GROUP_SYSTEM 
  GROUP_UNKNOWN 
  GROUP_VIRTUALIZATION 
  
  INFO_AVAILABLE 
  INFO_BLOCKED 
  INFO_BUGFIX 
  INFO_CLEANUP 
  INFO_DOWNLOADING 
  INFO_ENHANCEMENT 
  INFO_IMPORTANT 
  INFO_INSTALLED 
  INFO_INSTALLING 
  INFO_LOW 
  INFO_NORMAL 
  INFO_OBSOLETING 
  INFO_REMOVING 
  INFO_SECURITY 
  INFO_UNKNOWN 
  INFO_UPDATING 

  PK_ERROR_ENUM_UNKNOWN 
  PK_ERROR_ENUM_OOM 
  PK_ERROR_ENUM_NO_CACHE 
  PK_ERROR_ENUM_NO_NETWORK 
  PK_ERROR_ENUM_NOT_SUPPORTED 
  PK_ERROR_ENUM_INTERNAL_ERROR 
  PK_ERROR_ENUM_GPG_FAILURE 
  PK_ERROR_ENUM_FILTER_INVALID 
  PK_ERROR_ENUM_PACKAGE_ID_INVALID 
  PK_ERROR_ENUM_TRANSACTION_ERROR 
  PK_ERROR_ENUM_TRANSACTION_CANCELLED 
  PK_ERROR_ENUM_PACKAGE_NOT_INSTALLED 
  PK_ERROR_ENUM_PACKAGE_NOT_FOUND 
  PK_ERROR_ENUM_PACKAGE_ALREADY_INSTALLED 
  PK_ERROR_ENUM_PACKAGE_DOWNLOAD_FAILED 
  PK_ERROR_ENUM_GROUP_NOT_FOUND 
  PK_ERROR_ENUM_GROUP_LIST_INVALID 
  PK_ERROR_ENUM_DEP_RESOLUTION_FAILED 
  PK_ERROR_ENUM_CREATE_THREAD_FAILED 
  PK_ERROR_ENUM_REPO_NOT_FOUND 
  PK_ERROR_ENUM_CANNOT_REMOVE_SYSTEM_PACKAGE 
  PK_ERROR_ENUM_PROCESS_KILL 
  PK_ERROR_ENUM_FAILED_INITIALIZATION 
  PK_ERROR_ENUM_FAILED_FINALISE 
  PK_ERROR_ENUM_FAILED_CONFIG_PARSING 
  PK_ERROR_ENUM_CANNOT_CANCEL 
  PK_ERROR_ENUM_CANNOT_GET_LOCK 
  PK_ERROR_ENUM_NO_PACKAGES_TO_UPDATE 
  PK_ERROR_ENUM_CANNOT_WRITE_REPO_CONFIG 
  PK_ERROR_ENUM_LOCAL_INSTALL_FAILED 
  PK_ERROR_ENUM_BAD_GPG_SIGNATURE 
  PK_ERROR_ENUM_MISSING_GPG_SIGNATURE 
  PK_ERROR_ENUM_CANNOT_INSTALL_SOURCE_PACKAGE 
  PK_ERROR_ENUM_REPO_CONFIGURATION_ERROR 
  PK_ERROR_ENUM_NO_LICENSE_AGREEMENT 
  PK_ERROR_ENUM_FILE_CONFLICTS 
  PK_ERROR_ENUM_REPO_NOT_AVAILABLE 
  PK_ERROR_ENUM_INVALID_PACKAGE_FILE 
  PK_ERROR_ENUM_PACKAGE_INSTALL_BLOCKED 
  
  PK_RESTART_ENUM_UNKNOWN
  PK_RESTART_ENUM_NONE
  PK_RESTART_ENUM_SYSTEM
  PK_RESTART_ENUM_SESSION
  PK_RESTART_ENUM_APPLICATION
  
  PK_STATUS_ENUM_UNKNOWN 
  PK_STATUS_ENUM_WAIT 
  PK_STATUS_ENUM_SETUP 
  PK_STATUS_ENUM_RUNNING 
  PK_STATUS_ENUM_QUERY 
  PK_STATUS_ENUM_INFO 
  PK_STATUS_ENUM_REFRESH_CACHE 
  PK_STATUS_ENUM_REMOVE 
  PK_STATUS_ENUM_DOWNLOAD 
  PK_STATUS_ENUM_INSTALL 
  PK_STATUS_ENUM_UPDATE 
  PK_STATUS_ENUM_CLEANUP 
  PK_STATUS_ENUM_OBSOLETE 
  PK_STATUS_ENUM_DEP_RESOLVE 
  PK_STATUS_ENUM_SIG_CHECK 
  PK_STATUS_ENUM_TEST_COMMIT 
  PK_STATUS_ENUM_COMMIT 
  PK_STATUS_ENUM_REQUEST 
  PK_STATUS_ENUM_FINISHED 
  PK_STATUS_ENUM_CANCEL 
  PK_STATUS_ENUM_DOWNLOAD_REPOSITORY 
  PK_STATUS_ENUM_DOWNLOAD_PACKAGELIST 
  PK_STATUS_ENUM_DOWNLOAD_FILELIST 
  PK_STATUS_ENUM_DOWNLOAD_CHANGELOG 
  PK_STATUS_ENUM_DOWNLOAD_GROUP 
  PK_STATUS_ENUM_DOWNLOAD_UPDATEINFO 

  PK_DISTRO_UPGRADE_ENUM_UNKNOWN
  PK_DISTRO_UPGRADE_ENUM_STABLE
  PK_DISTRO_UPGRADE_ENUM_UNSTABLE

  );

use constant {
  FILTER_BASENAME => "basename",
  FILTER_DEVELOPMENT => "devel",
  FILTER_FREE => "free",
  FILTER_GUI => "gui",
  FILTER_INSTALLED => "installed",
  FILTER_NEWEST => "newest",
  FILTER_NONE => "none",
  FILTER_NOT_BASENAME => "~basename",
  FILTER_NOT_DEVELOPMENT => "~devel",
  FILTER_NOT_FREE => "~free",
  FILTER_NOT_GUI => "~gui",
  FILTER_NOT_INSTALLED => "~installed",
  FILTER_NOT_NEWEST => "~newest",
  FILTER_NOT_SUPPORTED => "~supported",
  FILTER_NOT_VISIBLE => "~visible",
  FILTER_SUPPORTED => "supported",
  FILTER_UNKNOWN => "unknown",
  FILTER_VISIBLE => "visible",
  FILTER_DOWNLOADED => 'downloaded',
  FILTER_NOT_DOWNLOADED => '~downloaded',
  FILTER_APPLICATION => 'application',
  FILTER_NOT_APPLICATION => '~application',

  GROUP_ACCESSIBILITY => "accessibility",
  GROUP_ACCESSORIES => "accessories",
  GROUP_ADMIN_TOOLS => "admin-tools",
  GROUP_COMMUNICATION => "communication",
  GROUP_DESKTOP_GNOME => "desktop-gnome",
  GROUP_DESKTOP_KDE => "desktop-kde",
  GROUP_DESKTOP_OTHER => "desktop-other",
  GROUP_DESKTOP_XFCE => "desktop-xfce",
  GROUP_EDUCATION => "education",
  GROUP_FONTS => "fonts",
  GROUP_GAMES => "games",
  GROUP_GRAPHICS => "graphics",
  GROUP_INTERNET => "internet",
  GROUP_LEGACY => "legacy",
  GROUP_LOCALIZATION => "localization",
  GROUP_MAPS => "maps",
  GROUP_MULTIMEDIA => "multimedia",
  GROUP_NETWORK => "network",
  GROUP_OFFICE => "office",
  GROUP_OTHER => "other",
  GROUP_POWER_MANAGEMENT => "power-management",
  GROUP_PROGRAMMING => "programming",
  GROUP_PUBLISHING => "publishing",
  GROUP_REPOS => "repos",
  GROUP_SECURITY => "security",
  GROUP_SERVERS => "servers",
  GROUP_SYSTEM => "system",
  GROUP_UNKNOWN => "unknown",
  GROUP_VIRTUALIZATION => "virtualization",

  INFO_AVAILABLE => "available",
  INFO_BLOCKED => "blocked",
  INFO_BUGFIX => "bugfix",
  INFO_CLEANUP => "cleanup",
  INFO_DOWNLOADING => "downloading",
  INFO_ENHANCEMENT => "enhancement",
  INFO_IMPORTANT => "important",
  INFO_INSTALLED => "installed",
  INFO_INSTALLING => "installing",
  INFO_LOW => "low",
  INFO_NORMAL => "normal",
  INFO_OBSOLETING => "obsoleting",
  INFO_REMOVING => "removing",
  INFO_SECURITY => "security",
  INFO_UNKNOWN => "unknown",
  INFO_UPDATING => "updating",

  PK_ERROR_ENUM_UNKNOWN => "unknown",
  PK_ERROR_ENUM_OOM => "out-of-memory",
  PK_ERROR_ENUM_NO_CACHE => "no-cache",
  PK_ERROR_ENUM_NO_NETWORK => "no-network",
  PK_ERROR_ENUM_NOT_SUPPORTED => "not-supported",
  PK_ERROR_ENUM_INTERNAL_ERROR => "internal-error",
  PK_ERROR_ENUM_GPG_FAILURE => "gpg-failure",
  PK_ERROR_ENUM_FILTER_INVALID => "filter-invalid",
  PK_ERROR_ENUM_PACKAGE_ID_INVALID => "package-id-invalid",
  PK_ERROR_ENUM_TRANSACTION_ERROR => "transaction-error",
  PK_ERROR_ENUM_TRANSACTION_CANCELLED => "transaction-cancelled",
  PK_ERROR_ENUM_PACKAGE_NOT_INSTALLED => "package-not-installed",
  PK_ERROR_ENUM_PACKAGE_NOT_FOUND => "package-not-found",
  PK_ERROR_ENUM_PACKAGE_ALREADY_INSTALLED => "package-already-installed",
  PK_ERROR_ENUM_PACKAGE_DOWNLOAD_FAILED => "package-download-failed",
  PK_ERROR_ENUM_GROUP_NOT_FOUND => "group-not-found",
  PK_ERROR_ENUM_GROUP_LIST_INVALID => "group-list-invalid",
  PK_ERROR_ENUM_DEP_RESOLUTION_FAILED => "dep-resolution-failed",
  PK_ERROR_ENUM_CREATE_THREAD_FAILED => "create-thread-failed",
  PK_ERROR_ENUM_REPO_NOT_FOUND => "repo-not-found",
  PK_ERROR_ENUM_CANNOT_REMOVE_SYSTEM_PACKAGE => "cannot-remove-system-package",
  PK_ERROR_ENUM_PROCESS_KILL => "process-kill",
  PK_ERROR_ENUM_FAILED_INITIALIZATION => "failed-initialization",
  PK_ERROR_ENUM_FAILED_FINALISE => "failed-finalise",
  PK_ERROR_ENUM_FAILED_CONFIG_PARSING => "failed-config-parsing",
  PK_ERROR_ENUM_CANNOT_CANCEL => "cannot-cancel",
  PK_ERROR_ENUM_CANNOT_GET_LOCK => "cannot-get-lock",
  PK_ERROR_ENUM_NO_PACKAGES_TO_UPDATE => "no-packages-to-update",
  PK_ERROR_ENUM_CANNOT_WRITE_REPO_CONFIG => "cannot-write-repo-config",
  PK_ERROR_ENUM_LOCAL_INSTALL_FAILED => "local-install-failed",
  PK_ERROR_ENUM_BAD_GPG_SIGNATURE => "bad-gpg-signature",
  PK_ERROR_ENUM_MISSING_GPG_SIGNATURE => "missing-gpg-signature",
  PK_ERROR_ENUM_CANNOT_INSTALL_SOURCE_PACKAGE => "cannot-install-source-package",
  PK_ERROR_ENUM_REPO_CONFIGURATION_ERROR => "repo-configuration-error",
  PK_ERROR_ENUM_NO_LICENSE_AGREEMENT => "no-license-agreement",
  PK_ERROR_ENUM_FILE_CONFLICTS => "file-conflicts",
  PK_ERROR_ENUM_REPO_NOT_AVAILABLE => "repo-not-available",
  PK_ERROR_ENUM_INVALID_PACKAGE_FILE => "invalid-package-file",
  PK_ERROR_ENUM_PACKAGE_INSTALL_BLOCKED => "package-install-blocked",

  PK_RESTART_ENUM_UNKNOWN => "unknown",
  PK_RESTART_ENUM_NONE => "none",
  PK_RESTART_ENUM_SYSTEM => "system",
  PK_RESTART_ENUM_SESSION => "session",
  PK_RESTART_ENUM_APPLICATION => "application",

  PK_STATUS_ENUM_UNKNOWN => "unknown",
  PK_STATUS_ENUM_WAIT => "wait",
  PK_STATUS_ENUM_SETUP => "setup",
  PK_STATUS_ENUM_RUNNING => "running",
  PK_STATUS_ENUM_QUERY => "query",
  PK_STATUS_ENUM_INFO => "info",
  PK_STATUS_ENUM_REFRESH_CACHE => "refresh-cache",
  PK_STATUS_ENUM_REMOVE => "remove",
  PK_STATUS_ENUM_DOWNLOAD => "download",
  PK_STATUS_ENUM_INSTALL => "install",
  PK_STATUS_ENUM_UPDATE => "update",
  PK_STATUS_ENUM_CLEANUP => "cleanup",
  PK_STATUS_ENUM_OBSOLETE => "obsolete",
  PK_STATUS_ENUM_DEP_RESOLVE => "dep-resolve",
  PK_STATUS_ENUM_SIG_CHECK => "sig-check",
  PK_STATUS_ENUM_TEST_COMMIT => "test-commit",
  PK_STATUS_ENUM_COMMIT => "commit",
  PK_STATUS_ENUM_REQUEST => "request",
  PK_STATUS_ENUM_FINISHED => "finished",
  PK_STATUS_ENUM_CANCEL => "cancel",
  PK_STATUS_ENUM_DOWNLOAD_REPOSITORY => "download-repository",
  PK_STATUS_ENUM_DOWNLOAD_PACKAGELIST => "download-package",
  PK_STATUS_ENUM_DOWNLOAD_FILELIST => "download-filelist",
  PK_STATUS_ENUM_DOWNLOAD_CHANGELOG => "download-changelog",
  PK_STATUS_ENUM_DOWNLOAD_GROUP => "download-group",
  PK_STATUS_ENUM_DOWNLOAD_UPDATEINFO => "download-updateinfo",

  PK_DISTRO_UPGRADE_ENUM_UNKNOWN => "unknown",
  PK_DISTRO_UPGRADE_ENUM_STABLE => "stable",
  PK_DISTRO_UPGRADE_ENUM_UNSTABLE => "unstable",

};

1;
