(*
 * Copyright (c) 2001 Stefan Kral
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *)


type p4rflag = P4RFlag_Zero
and p4rop =
    P4ROp_MMXReg of P4Basics.p4rmmxreg
  | P4ROp_IntReg of P4Basics.p4rintreg
  | P4ROp_MemOp of P4Basics.p4memop
  | P4ROp_IP
  | P4ROp_Flag of p4rflag
  | P4ROp_MMXState
  | P4ROp_MemoryState
  | P4ROp_Stack

val zeroflag : p4rop
val mmxstackcell : int -> p4rop

module ResMap :
  sig
    type key = p4rop
    and (+'a) t
    val empty : 'a t
    val add : key:key -> data:'a -> 'a t -> 'a t
    val find : key -> 'a t -> 'a
    val remove : key -> 'a t -> 'a t
    val mem : key -> 'a t -> bool
    val iter : f:(key:key -> data:'a -> unit) -> 'a t -> unit
    val map : f:('a -> 'b) -> 'a t -> 'b t
    val mapi : f:(key -> 'a -> 'b) -> 'a t -> 'b t
    val fold : f:(key:key -> data:'a -> 'b -> 'b) -> 'a t -> init:'b -> 'b
  end

val resmap_findE : ResMap.key -> 'a list ResMap.t -> 'a list
val resmap_addE : ResMap.key -> 'a -> 'a list ResMap.t -> 'a list ResMap.t
val resmap_addE' : 'a -> ResMap.key -> 'a list ResMap.t -> 'a list ResMap.t
val resmap_find : ResMap.key -> 'a ResMap.t -> 'a option

val raddrToRops : P4Basics.p4raddr -> p4rop list
val intuopToSrcrops : p4rop -> P4Basics.p4intunaryop -> p4rop list
val intcpyuopToSrcrops : P4Basics.p4intcpyunaryop -> 'a list
val branchconditionToSrcrops : P4Basics.p4branchcondition -> p4rop list
val simduopToSrcrops : 'a -> P4Basics.p4simdunaryop -> 'a list
val simdcpyuopToSrcrops : P4Basics.p4simdcpyunaryop -> 'a list
val rinstrToSrcrops' : P4Basics.p4rinstr -> p4rop list
val intuopToDstrops : p4rop -> P4Basics.p4intunaryop -> (p4rop * int) list
val intcpyuopToDstrops : 'a -> P4Basics.p4intcpyunaryop -> ('a * int) list

val simduopToLatency : P4Basics.p4simdunaryop -> int
val simdbopToLatency : P4Basics.p4simdbinop -> int

val p4rinstrToSrcp4rops : P4Basics.p4rinstr -> p4rop list
val p4rinstrToDstp4rops : P4Basics.p4rinstr -> (p4rop * int) list

val p4rinstrToMaxlatency : P4Basics.p4rinstr -> int

val p4rinstrCannotRollOverP4rinstr :
  P4Basics.p4rinstr -> P4Basics.p4rinstr -> bool
