/*
 * P3Scan v2.1
 *
 * (C) 2003-2005 by Jack S. Lai <laitcg@cox.net>
 *
 * It's intent is to provide a follow on program to POP3-Virusscan-Proxy 0.4
 * by Folke Ashberg <folke@ashberg.de>.
 *
 * It is based upon his program but provides numerous changes to include
 * scanning pop3 mail for spam, hardening the program, addaption to todays
 * email environment, and many other changes.
 *
 * The initial release of p3scan includes patches made and submitted to the
 * original project but were never incorporated. Please see the README for
 * further information.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _P3SCAN_H
#define _P3SCAN_H

#include <syslog.h>           /* do_log */
#include <arpa/inet.h>        /* config */

#define PROGNAME              "P3Scan"
#define VERSION               "2.1"
#define MAX_PSEUDO_ARGV       50
#define MESSAGE_NOVIRINFO     "<no virusinfo could be examined>"
#define FILEDEL               "The infected message has been deleted."
#define SVRCMD                "NOOP"
#define PERIOD                "."
#define BOGUSX                "X-P3Scan: Due to an extremely large attachment you see this message line."

#define CONFIG_STATE_CMDPRE   1
#define CONFIG_STATE_FILE     2
#define CONFIG_STATE_CMD      3

#define SCANNER_INIT_NO       0
#define SCANNER_INIT_OK       1
#define SCANNER_INIT_NULL     2 /* scanner needs no init */
#define SCANNER_INIT_ERR      -1

#define SCANNER_RET_OK        0
#define SCANNER_RET_ERR       -1
#define SCANNER_RET_VIRUS     2
#define SCANNER_RET_CRIT      3

#define MAX_VIRUS_CODES       16

#if defined(__USE_FILE_OFFSET64) || defined(__USE_LARGEFILE64)
#define FSTAT(a, b) fstat64(a,b)
#define LSTAT(a, b) lstat64(a,b)
#define STAT(a, b) stat64(a,b)
#define stat_t stat64
#else
#define FSTAT(a, b) fstat(a,b)
#define LSTAT(a, b) lstat(a,b)
#define STAT(a, b) stat(a,b)
#define stat_t stat
#endif

#define SETIFNULL(a,b) if (!a) a=b  /* wow, that's magic */
#define NONULL(x) ( x==NULL ? "" : x) /* this is nice, found in the mutt code */

#define TRIM(a) \
{ \
   int len=0; \
   while ((a)[len] && isspace((a)[len])) len++; \
   memmove((a),&(a)[len], strlen(&(a)[len])+1); \
   while ((len=strlen(a))>0 && isspace((a)[len-1])) (a)[len-1]='\0'; \
}

typedef struct proxycontext {
   struct  linebuf   *serverbuf;
   struct  linebuf   *clientbuf;
   struct  linebuf   *hdrbuf;
   struct  sockaddr_in   client_addr;
   struct  sockaddr_in   server_addr;
   size_t        socksize;
   off_t         hdroffset;
   time_t        now;
   int           client_fd;
   int           server_fd;
   int           header_fd;
   int           ismail;
   unsigned int  msgnum;
   int           header_exists;
   int           fakehdrdone;
   int           notified;
   int           noop;
   int           errmsg;
   struct paramlist *params;
   int           mailcount;
   unsigned long bytecount;
   int           gobogus;
   int           boguspos;
   int           hdrdate;
   int           hdrfrom;
   int           hdrto;
   char          mailfile[4096];
   char          maildir[4096]; /* mailfile.content */
   char          p3shdrfile[4096];
   char          cbuff[1];
   char          * filename;
   char          * scanthis; /* depending on demime linked to mailfile / maildir */
   char          * virinfo; /* has to be filled from the scanner */
   char          * filestatus; /* infected mail kept or deleted */
   int           scannerinit; /* see SCANNER_INIT_* */
} proxycontext;

typedef struct scanner_t {
   char    *name;
   char    *descr;
   int     (*init1)(void);
   int     (*init2)(struct proxycontext *);
   int     (*scan)(struct proxycontext *, char ** virname);
   void    (*uninit2)(struct proxycontext *);
   void    (*uninit1)(void);
   int     dirscan;
} scanner_t;


typedef struct configuration_t {
   int         maxchilds;
   char *      renattach;
   char *      runasuser;
   char *      virusdirbase;
   char *      virusdir;
   char *      notifydir;
   char *      virustemplate;
   char *      virusscanner;
   int         viruscode[MAX_VIRUS_CODES + 1];
   int         gvcode[MAX_VIRUS_CODES + 1];
   char *      virusregexp;
   int         virusregexpsub;
   int         demime;
   char *      pidfile;
   char *      syslogname;
   char *      configfile;
   int         debug;
   char *      overwrite;
   struct      sockaddr_in addr;
   struct      sockaddr_in targetaddr;
   scanner_t * scanner;
   int         scannerenabled;
   int         quiet;
   int         checkspam;
   char *      spamcheck;
   unsigned long freespace;
   int         delit;
   char *      dspamuser;
   int         ispam;
   int         broken;
   char *      subject;
   char *      notify;
   char *      ispspam;
} configuration_t;

extern void do_log(int level, const char *fmt,...);

void context_uninit(struct proxycontext * p);

#endif
