
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: meta_info.c,v 1.6 2006/02/08 20:46:46 mschwerin Exp $
 *
 */
#include "config.h"

#include "xine.h"

#include "codeset.h"
#include "heap.h"
#include "i18n.h"
#include "logger.h"
#include "meta_info.h"

/*
 * The returned string has to be freed using ho_free.
 */
char *
meta_info_get_from_stream (xine_stream_t * stream, meta_info_t type)
{
    char *meta = NULL;
    const char *xmeta = xine_get_meta_info (stream, type);

    if (xmeta) {
        // strip whitespace from the beginning of the string
        while ((xmeta[0] == ' ') || (xmeta[0] == '\t') || (xmeta[0] == '\n')
               || (xmeta[0] == '\r'))
            xmeta = (char *) (xmeta + 1);

        // convert the string to our local codeset
        char *codeset = get_system_encoding ();
        recode_t *xr = recode_init ("utf8", codeset);
        if (codeset)
            ho_free (codeset);
        meta = recode (xr, xmeta);
        recode_done (xr);
    }

    return meta;
}

/*
 * The returned string has to be freed using ho_free.
 */
char *
meta_info_get_from_mrl (const char *mrl, meta_info_t type)
{
    char *meta = NULL;

    xine_t *xine = xine_new ();
    xine_init (xine);

    xine_stream_t *stream = xine_stream_new (xine, NULL, NULL);

    if (stream) {
        if (xine_open (stream, mrl) == 1) {
            meta = meta_info_get_from_stream (stream, type);
        } else {
            error (_("Could not open '%s': %s!"), mrl, _("Unknown error"));
        }
        xine_dispose (stream);
    } else {
        error (_("Could not create stream!"));
    }

    xine_exit (xine);

    return meta;
}
