dnl
dnl checking for pthread
dnl
AC_DEFUN([AC_CHECK_PTHREAD], [
    AC_CHECK_LIB([pthread ], [pthread_create],
                 [THREAD_LIBS="-lpthread"],
                 [AC_MSG_ERROR(pthread is needed)])
    AC_SUBST(THREAD_LIBS)

    # we need PTHREAD_MUTEX_RECURSIVE
    pthread_CFLAGS=""
    original_CFLAGS=$CFLAGS
    AC_MSG_CHECKING(for PTHREAD_MUTEX_RECURSIVE)
    AC_TRY_COMPILE([ #include <pthread.h> ], [
        pthread_mutexattr_t attr;
        pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE); 
    ], [
        AC_MSG_RESULT(yes)
    ], [
        AC_MSG_RESULT(no)

        # glibc requires -D_GNU_SOURCE before it will declare
        # this macro
        AC_MSG_CHECKING(for PTHREAD_MUTEX_RECURSIVE using _GNU_SOURCE)
        CFLAGS="$CFLAGS -D_GNU_SOURCE"
        AC_TRY_COMPILE([ #include <pthread.h>], [
            pthread_mutexattr_t attr;
            pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
        ], [
            AC_MSG_RESULT(yes)
            pthread_CFLAGS="-D_GNU_SOURCE"
        ], [
            AC_MSG_RESULT(no)
            AC_MSG_ERROR([PTHREAD_MUTEX_RECURSIVE not found])
        ])
    ])
    CFLAGS="$original_CFLAGS $pthread_CFLAGS"
])
