'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Program manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH OWFS 1 2004 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B owfs
\- 1-wire filesystem
.SH SYNOPSIS
.B owfs
.so man1/cmdline_mini.1so
.I \-m mountdir
.SH "DESCRIPTION"
.so man1/description.1so
.SS owfs
.B owfs (1)
is the filesystem client of the 
.I OWFS
family of programs. It runs on linux, freebsd and Mac OS X, and requires the 
.I fuse
kernel module and library. (http://fuse.sourceforge.net) which is a user-mode filesystem driver.
.PP
Essentially, the entire 1-wire bus is mounted to a place in your filesystem. All the 1-wire devices are accessible using standard file operations (read, write, directory listing). The system is safe, no actual files are exposed, these files are virtual. Not all operations are supported. Specifically, file creation, deletion, linking and renaming are not allowed. (You can link from outside to a owfs file, but not the other way around).
.so man1/device.1so
.SH SPECIFIC OPTIONS
.SS \-m \-\-mountpoint=directory_path
Path of a directory to mount the 1-wire file system
.PP
The mountpoint is required. There is no default.
.SS \-\-allow_other
Shorthand for fuse mount option "\-o allow_other"  Allows uther users to see the fuse (owfs) mount point and file system. Requires a setting in /etc/fuse.conf as well.
.SS \-\-fuse-opt "options"
Sends options to the fuse-mount process. Options should be quoted, e.g. "\"\-o allow_other\"" .
.so man1/temperature.1so
.so man1/pressure.1so
.so man1/format.1so
.so man1/job_control.1so
.so man1/configuration.1so
.so man1/help.1so
.so man1/timeout.1so
.SH EXAMPLE
.TP
owfs \-d /dev/ttyS0 \-m /mnt/1wire
Bus master on serial port
.TP
owfs \-F \-u \-m /mnt/1wire
USB adapter, temperatures reported in Fahrenheit
.TP
owfs \-s 10.0.1.2:4304 \-m /mnt/1wire
Connect to an 
.B owserver (1)
process that was started on another machine at tcp port 4304
.SH SEE ALSO
.so man1/seealso.1so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
