/**
  @file bt-gconf.h

  Bluetooth connectivity GConf definitions

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _BT_GCONF_H_
#define _BT_GCONF_H_

#include <glib.h>

/* OSSO specific stuff */
#define BTCOND_GCONF_PATH       "/system/osso/connectivity/BT"

/** String list of selected BT devices we want to work with */
#define BTCOND_GCONF_SELECTED   BTCOND_GCONF_PATH "/selected"

/** Preferred device in selected list */
#define BTCOND_GCONF_PREFERRED   BTCOND_GCONF_PATH "/preferred"

/* End of OSSO specific stuff */


/* gnome-bluetooth compatible stuff */

#define GNOME_BT_GCONF          "/system/bluetooth"

/** Subdirectories found in /system/bluetooth/device/ */
#define GNOME_BT_DEVICES        GNOME_BT_GCONF "/devices"

/** GConf path of device specific information subdirectories */
#define GNOME_BT_DEVICE         GNOME_BT_GCONF "/device"

/** Get GConf directory where information about a specific device is stored
 * @param bda   Bluetooth address of device
 * @returns     GConf directory for device information. Free with g_free().
 */
#define GNOME_BT_DEV_PATH(bda)  g_strdup_printf("%s/%s", \
                                                GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device name
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device name. Free with g_free().
 */
#define GNOME_BT_DEV_NAME(bda)  g_strdup_printf("%s/%s/name", \
                                                GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device icon
 * This stores only the filename of the icon (not the whole path)
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device icon. Free with g_free().
 */
#define GNOME_BT_DEV_ICON(bda)  g_strdup_printf("%s/%s/icon", \
                                                GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device alias
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device alias. Free with g_free().
 */
#define GNOME_BT_DEV_ALIAS(bda) g_strdup_printf("%s/%s/alias", \
                                                GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device connectivity permissions
 * @param bda   Bluetooth address of device
 * @returns     GConf path of permissions. Free with g_free().
 */
#define GNOME_BT_DEV_PERM(bda)  g_strdup_printf("%s/%s/permission", \
                                                GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device class
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device class. Free with g_free().
 */
#define GNOME_BT_DEV_CLASS(bda)  g_strdup_printf("%s/%s/class", \
                                                 GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device DUN profile support for GSM network
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device class. Free with g_free().
 */
#define GNOME_BT_DEV_DUN_GSM(bda)  g_strdup_printf("%s/%s/dun_gsm", \
                                                   GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device DUN profile support for UMTS network
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device class. Free with g_free().
 */
#define GNOME_BT_DEV_DUN_UMTS(bda)  g_strdup_printf("%s/%s/dun_umts", \
                                                    GNOME_BT_DEVICE, (bda))

/** Get GConf path of BT device DUN profile support for CDMA network
 * @param bda   Bluetooth address of device
 * @returns     GConf path of device class. Free with g_free().
 */
#define GNOME_BT_DEV_DUN_CDMA(bda)  g_strdup_printf("%s/%s/dun_cdma", \
                                                    GNOME_BT_DEVICE, (bda))

#endif /* _BT_GCONF_H_ */
