/* (C) 2004-2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#include <UnitTest++.h>
#include <map>
#include <vector>
#include <string>
#include <iostream>
#include <glib.h>
#include "osgCal/Model"

#include "osgcal.h"

#ifdef WIN32
#define DATA_DIR "../../data/MC/"
#endif

std::string DATA=DATA_DIR;

#ifdef WIN32
#undef main
#endif

int main(int argc, char *argv[])
{
	return UnitTest::RunAllTests();
}

namespace osgCal {
  bool Model::installOutfitFromXMLString(const std::string& xmlString) { return true;}


  Model::Model() {}
  Model::Model(Model const&, osg::CopyOp const&) {}
  Model::~Model() {}
  bool Model::setCoreModel(osgCal::CoreModel*) { return true;}
  bool Model::setUseVertexProgram(bool, unsigned int) { return true;}
  bool Model::initOutfitFromXMLString(std::string const&, std::vector<std::string> *) { return true;}
  bool Model::create() { return true;}
  bool Model::applyParameterFromOutfitDescription() { return true;}
};


osgUtil::SceneView* osgViewer::GetSceneView() { return 0;}
bool ParseDirectory(const std::string& input, std::vector<std::string>& result);
osg::Group* osgViewer::GetRoot() { return 0;}

TEST(parseDirectoryGood)
{
  std::map<std::string,std::string> map;
  std::vector<std::string> result;
  bool rc = ParseDirectory(DATA,result);
  CHECK_EQUAL(true, rc);
  for (int i = 0; i < (int)result.size(); i++)
    map[result[i] ] = result[i];
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Action.xaf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Close_Head.xmf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Cube.xmf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Dress.xmf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Eyes.xmf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC1.blend") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC1.cfg") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC1.xsf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC2.blend") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC2.cfg") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC2.xsf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC3.blend") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC3.cfg") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"MC3.xsf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Men_torso.xmf") != map.end());
  CHECK_EQUAL(true, map.find(DATA+G_DIR_SEPARATOR_S+"Pant.xmf") != map.end());
}

TEST(parseDirectoryBad)
{
  std::map<std::string,std::string> map;
  std::vector<std::string> result;
  bool rc = ParseDirectory("\\aol?/",result);
  CHECK_EQUAL(false, rc);
}
