/*
 * textbox-item.h
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __TEXTBOX_ITEM_H
#define __TEXTBOX_ITEM_H

#include <config.h>
#include <gtk/gtk.h>
#include "schematic-view.h"
#include "sheet-item.h"
#include "textbox.h"

#define TEXTBOX_ITEM(obj)          GTK_CHECK_CAST (obj, textbox_item_get_type (), TextboxItem)
#define TEXTBOX_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, textbox_item_get_type (), TextboxItemClass)
#define IS_TEXTBOX_ITEM(obj)       GTK_CHECK_TYPE (obj, textbox_item_get_type ())

typedef struct _TextboxItemPriv TextboxItemPriv; 
     
typedef enum {
	TEXTBOX_DIR_NONE = 0,
	TEXTBOX_DIR_HORIZ = 1,
	TEXTBOX_DIR_VERT = 2,
	TEXTBOX_DIR_DIAG = 3
} TextboxDir;

typedef struct {
	SheetItem parent_object;
	TextboxItemPriv *priv;
} TextboxItem;

typedef struct {
	SheetItemClass parent_class;
} TextboxItemClass;

GtkType      textbox_item_get_type (void);
TextboxItem *textbox_item_new (Sheet *sheet, Textbox *textbox);
void         textbox_item_signal_connect_placed (TextboxItem *textbox_item, SchematicView *sv);


#endif
