/* TODO:

Hoppa ver wires som inte connectar.

 -> Mste lagra connections dots i SheetNode.
 -> NodeItem
 
 -> Byt namn p SheetNode till Node.
 
 -> Inte kunna selecta (etc) NodeItem.
 
 -> Inte autoconnect p wires som korsas.
 -> Mjlighet att connecta tv wires som korsas.

*/



/*
 * node-item.c
 *
 * Copyright (C) 2000  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gnome.h>
#include "node-item.h"

static void node_item_init		(NodeItem		 *item);
static void node_item_class_init	(NodeItemClass	 *klass);

struct _NodeItemPriv {
	GnomeCanvasItem *dot_item;
};

static GnomeCanvasGroupClass *parent_class = NULL;


GtkType
node_item_get_type (void)
{
	static GtkType item_type = 0;
	
	if (!item_type)
	{
		static const GtkTypeInfo item_info =
		{
			"NodeItem",
			sizeof (NodeItem),
			sizeof (NodeItemClass),
			(GtkClassInitFunc) node_item_class_init,
			(GtkObjectInitFunc) node_item_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};
		
		item_type = gtk_type_unique (gnome_canvas_group_get_type (), &item_info);
	}
	
	return item_type;
}

static void
node_item_class_init (NodeItemClass *klass)
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) klass;
	
	parent_class = gtk_type_class (gnome_canvas_group_get_type ());
	
}


static void
node_item_init (NodeItem *item)
{
	item->priv = g_new0 (NodeItemPriv, 1);
}

void
node_item_show_dot (NodeItem *item, gboolean show)
{	
	g_return_if_fail (item != NULL);
	g_return_if_fail (IS_NODE_ITEM (item));
	
	if (show) {
		if (item->priv->dot_item == NULL) { 
			item->priv->dot_item = gnome_canvas_item_new (
				GNOME_CANVAS_GROUP (item),
				gnome_canvas_ellipse_get_type (),
				"x1", -2.0,
				"y1", -2.0,
				"x2", 2.0,
				"y2", 2.0,
				"fill_color", "black",
				NULL);
		}
		
		gnome_canvas_item_show (item->priv->dot_item);
	} else {
		if (item->priv->dot_item != NULL)
			gnome_canvas_item_hide (item->priv->dot_item);
	}
}


