//                                               -*- C++ -*-
/**
 *  @file  t_Log_std.cxx
 *  @brief The test file of class Log for standard methods
 *
 *  Copyright (C) 2005-2014 Airbus-EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012)
 */
#include "OTtestcode.hxx"
#include "OStream.hxx"

#include "Log.hxx"

using namespace OT;
using namespace OT::Test;

const int N = 100;

void* printDebug(void*)
{
  for(int i = 0; i < N; i++) LOGDEBUG(OSS() << "Debug #" << i);
  return NULL;
}


void* printInfo(void*)
{
  for(int i = 0; i < N; i++) LOGINFO(OSS() << "Info #" << i);
  return NULL;
}


void* printWrapper(void*)
{
  for(int i = 0; i < N; i++) LOGWRAPPER(OSS() << "Wrapper #" << i);
  return NULL;
}


void* printUser(void*)
{
  for(int i = 0; i < N; i++) LOGUSER(OSS() << "User #" << i);
  return NULL;
}


void* printWarn(void*)
{
  for(int i = 0; i < N; i++) LOGWARN(OSS() << "Warn #" << i);
  return NULL;
}


void* printError(void*)
{
  for(int i = 0; i < N; i++) LOGERROR(OSS() << "Error #" << i);
  return NULL;
}


void* printTrace(void*)
{
  for(int i = 0; i < N; i++) LOGTRACE(OSS() << "Trace #" << i);
  return NULL;
}


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  ExitCodeValue rc = ExitCode::Success;

  const int nbThreads = 128;
  pthread_t Threads[nbThreads];

  const int nbFunctions = 7;
  typedef void * (*FUNC) (void *);
  FUNC Functions[nbFunctions] = { printDebug, printInfo, printWrapper, printUser, printWarn, printError, printTrace };

  Log::Show( Log::ALL );
  Log::SetFile("Log_check.log");

  // Create a thread for messages of every level
  for (int i = 0; i < nbThreads; ++i)
    pthread_create( Threads + i, 0, Functions[i % nbFunctions], 0 );

  // Wait for threads of messages
  for (int i = 0; i < nbThreads; ++i)
    pthread_join( Threads[i], 0 );

  // const UnsignedLong expectedLength = 4 * N;
  // UnsignedLong actualLength = Log::GetInstance().getSize();

  // if (actualLength != expectedLength) rc = ExitCode::Error;

  return rc;
}
