#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :

    # Default dimension parameter to evaluate the model 
    defaultDimension = 1

    # Amplitude values 
    amplitude = NumericalPoint(defaultDimension, 1.0)
    
    # Scale values 
    scale = NumericalPoint(defaultDimension, 1.0)

    # Second order model with parameters 
    myModel = SecondOrderModel(ExponentialCauchy(amplitude, scale))
    print  "myModel = " ,  myModel 

    tMin = 0.0
    points  = 64 # final instant is the 63-th point of the TimeGrid
    timeStep = 1.0 / (points - 1)

    # Build of the timeGrid
    myTimeGrid = RegularGrid(tMin, timeStep, points)
        
    myProcess0 = SpectralNormalProcess(myModel, myTimeGrid)
    print  "myProcess0 = " ,  repr(myProcess0)
    
    realization0 = myProcess0.getRealization()
    print "Realization = ", repr(realization0)
 
    # Using Frequency domain
    maximalFrequency = 1.0 
        
    myProcess1 = SpectralNormalProcess(myModel, maximalFrequency, points)
    print  "myProcess1 = " ,  repr(myProcess1)
    
    realization1 = myProcess1.getRealization()
    print "Realization = ", repr(realization1)
    
    # using a spectral model
    mySpecModel = SpectralModel(CauchyModel(amplitude, scale))
    print  "mySpecModel = " ,  mySpecModel 
    
    myProcess2 = SpectralNormalProcess(mySpecModel, myTimeGrid)
    print  "myProcess2 = " ,  repr(myProcess2)
    
    realization2 = myProcess2.getRealization()
    print "Realization = ", repr(realization2)

    myProcess3 = SpectralNormalProcess(mySpecModel, maximalFrequency, points)
    print "myProcess3 = " ,  repr(myProcess3)
    
    realization3 = myProcess3.getRealization()
    print "Realization = ", repr(realization3)

    # Test save / load 
    myStudy = Study()
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"))
    myStudy.add("myModel", myProcess0)
    myStudy.save()

    loadedStudy = Study()
    loadedStudy.setStorageManager(XMLStorageManager("testStudy.ot"))
    loadedStudy.load()
    myModelLoaded = SpectralNormalProcess()
    loadedStudy.fillObject("myModel", myModelLoaded)
    print  "loaded process =" ,  repr(myModelLoaded)
 

except :
    import sys
    print "t_SpectralNormalProcess_std.py", sys.exc_type, sys.exc_value
