// SWIG file Copula.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-02 11:44:01 +0100 (Mon, 02 Jan 2012) $
// Id : $Id: Copula.i 2287 2012-01-02 10:44:01Z schueller $

%{
#include "PythonWrappingFunctions.hxx"
#include "Copula.hxx"

namespace OT { 

  template <>
  struct traitsPythonType<OT::Copula>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OT::Copula
  convert<_PyObject_,OT::Copula>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OT__Copula, 0 |  0 ))) {
      OT::Copula * p_copula = reinterpret_cast< OT::Copula * >( ptr );
      return *p_copula;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OT__CopulaImplementation, 0 |  0 ))) {
      OT::CopulaImplementation * p_copula = reinterpret_cast< OT::CopulaImplementation * >( ptr );
      return *p_copula;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OT__Distribution, 0 |  0 ))) {
      OT::Distribution * p_dist = reinterpret_cast< OT::Distribution * >( ptr );
      return *p_dist;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OT__DistributionImplementation, 0 |  0 ))) {
      OT::DistributionImplementation * p_dist = reinterpret_cast< OT::DistributionImplementation * >( ptr );
      return *p_dist;

    } else if (isAPython<_PySequence_>( pyObj )) {
      check<_PySequence_>( pyObj );
      PyObject * newPyObj = PySequence_Fast( pyObj, "" );

      const UnsignedLong size = PySequence_Fast_GET_SIZE( newPyObj );
      if (size != 2) {
        throw OT::InvalidArgumentException(HERE) << "Sequence object has incorrect size " << size << ". Must be 2.";
      }
      PyObject * elt1 = PySequence_Fast_GET_ITEM( newPyObj, 0 );
      check<_PyObject_>( elt1 );
      PyObject * elt2 = PySequence_Fast_GET_ITEM( newPyObj, 1 );
      check<_PyString_>( elt2 );
      OT::Copula copula = convert<_PyObject_,OT::Copula>( elt1 );
      copula.setName( convert<_PyString_,OT::String>( elt2 ) );


      Py_XDECREF( newPyObj );
      return copula;

    } else {
      throw OT::InvalidArgumentException(HERE) << "Object passed as argument is neither a Copula nor an object convertible to a Copula";
    }
    return OT::Copula();
  }

} /* namespace OT */

%}

%typemap(in) const Copula & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    OT::CopulaImplementation * p_impl = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &p_impl, SWIG_TypeQuery("OT::CopulaImplementation *"), 0))) {
      temp = OT::Copula( *p_impl );
      $1 = &temp;
    } else throw OT::InvalidArgumentException(HERE) << "Object is not convertible to a distribution";
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const Copula & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, NULL, SWIG_TypeQuery("OT::CopulaImplementation *"), 0));
}

%apply const Copula & { const Copula &, const Copula &, const OT::Copula & };

%include Copula.hxx
namespace OT { %extend Copula { Copula(const Copula & other) { return new OT::Copula(other); } } }
