//                                               -*- C++ -*-
/**
 *  @file  Domain.cxx
 *  @brief Domain is the interface of DomainImplementation.cxx
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: Domain.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "Domain.hxx"
#include "PersistentObjectFactory.hxx"
#include "Interval.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(Domain);

/* Default constructor */
Domain::Domain():
  TypedInterfaceObject<DomainImplementation>(new Interval())
{
  // Nothing to do
}

Domain::Domain(const NumericalPoint & a, const NumericalPoint & b):
  TypedInterfaceObject<DomainImplementation>(new Interval(a,b))
{
  // Nothing to do
}

/* Default constructor */
Domain::Domain(const DomainImplementation & implementation):
  TypedInterfaceObject<DomainImplementation>(implementation.clone())
{
  // Nothing to do
}

/* Clone method */
Domain * Domain::clone() const
{
  return new Domain(*this);
}

UnsignedLong Domain::getDimension() const
{
  return getImplementation()->getDimension();
}


/* Check if the given point is inside of the closed interval */
Bool Domain::contains(const NumericalPoint & point) const
{
  return getImplementation()->contains(point);
}

} /* Namespace OpenTURNS */
