#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :

  #Log.Show( Log.ALL )

  # Variables
  vars = ({ "id_" : "F",
            "type_" : WrapperDataVariableType.IN,
            "regexp_" : "^\S*F\S*=\S*\R\S*$",
            "format_" : "F=%20.13G"  },
          
          { "id_" : "E",
            "type_" : WrapperDataVariableType.IN,
            "regexp_" : "^\S*E\S*=\S*\R\S*$",
            "format_" : "E=%20.13G"  },
          
          { "id_" : "Z",
            "type_" : WrapperDataVariableType.OUT,
            "regexp_" : "^\S*Z\S*=\S*(\R)\S*$" },
          )
  
  # Files
  files = ({ "id_" : "infile",
             "type_" : WrapperDataFileType.IN,
             "path_" : "inFILE_generic",
             "subst_" : "E,F"  },
           
           { "id_" : "outfile",
             "type_" : WrapperDataFileType.OUT,
             "path_" : "outFILE_generic",
             "subst_" : "Z"    },
           )
  
  # Parameters
  params = { "command_" : "python -c 'execfile(\"inFILE_generic\");Z=F*E;print \"Z=\",Z' > outFILE_generic",
             "userPrefix_" : "GenericWrapperTest",
             }
  
  # Framework
  framework = { "studyid_" : 1,
                "studycase_" : "SalOT",
                "componentname_" : "Beurk"
                }
  
  wrp = makeWrapper( vars, files, params, framework )
  #print wrp
  #wrp.writeFile( "wrp.xml" )

  model = NumericalMathFunction( wrp )
  #print f
  
  inP = NumericalPoint( (101,255) )
  print inP
  
  outP = model( inP )
  print outP

except :
  import sys
  print "t_WrapperFile_generic.py", sys.exc_type, sys.exc_value
