// SWIG file Distribution.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-02 11:44:01 +0100 (Mon, 02 Jan 2012) $
// Id : $Id: Distribution.i 2287 2012-01-02 10:44:01Z schueller $

%{
#include "Distribution.hxx"

namespace OT { 

  template <>
  struct traitsPythonType<OT::Distribution>
  {
    typedef _PyObject_ Type;
  };


  template <>
  inline
  OT::Distribution
  convert<_PyObject_,OT::Distribution>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (! SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OT::DistributionImplementation *"), 0 |  0 )))
      throw OT::InvalidArgumentException(HERE) << "Object passed as argument is not an object convertible to an DistributionImplementation";
    OT::DistributionImplementation * p_di = reinterpret_cast< OT::DistributionImplementation * >( ptr );
    return *p_di;
  }

} /* namespace OT */


%}

%template(DistributionImplementationTypedInterfaceObject)           OT::TypedInterfaceObject<OT::DistributionImplementation>;

%typemap(in) const Distribution & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    OT::DistributionImplementation * p_impl = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &p_impl, SWIG_TypeQuery("OT::DistributionImplementation *"), 0))) {
      temp = OT::Distribution( *p_impl );
      $1 = &temp;
    } else throw OT::InvalidArgumentException(HERE) << "Object is not convertible to a distribution";
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const Distribution & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, NULL, SWIG_TypeQuery("OT::DistributionImplementation *"), 0));
}

%apply const Distribution & { const Distribution &, const Distribution &, const OT::Distribution & };

%include Distribution.hxx
//%copyctor Distribution;

namespace OT {  

%extend Distribution {

Distribution(const Distribution & other) { return new OT::Distribution(other); }

}
}
