//                                               -*- C++ -*-
/**
 *  @file  RayleighFactory.hxx
 *  @brief Factory for Rayleigh distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu. 10 mai 2007) $
 *  Id:      $Id: RayleighFactory.hxx 434 2007-05-10 14:43:31Z dutka $
 */
#ifndef OPENTURNS_RAYLEIGHFACTORY_HXX
#define OPENTURNS_RAYLEIGHFACTORY_HXX

#include "DistributionImplementationFactory.hxx"
#include "Rayleigh.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class RayleighFactory
 */
class RayleighFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  RayleighFactory();

  /** Virtual constructor */
  virtual RayleighFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  Rayleigh * build(const NumericalSample & sample) const;
  Rayleigh * build(const NumericalPointCollection & parameters) const;
  Rayleigh * build() const;

}; /* class RayleighFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_RAYLEIGHFACTORY_HXX */
