//                                               -*- C++ -*-
/**
 *  @file  NormalCopulaFactory.hxx
 *  @brief Factory for NormalCopula distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: NormalCopulaFactory.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_NORMALCOPULAFACTORY_HXX
#define OPENTURNS_NORMALCOPULAFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "NormalCopula.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class NormalCopulaFactory
 */
class NormalCopulaFactory
  : public DistributionImplementationFactory
{
public:


  /** Default constructor */
  NormalCopulaFactory();

  /** Virtual constructor */
  virtual NormalCopulaFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  NormalCopula * build(const NumericalSample & sample) const;
  NormalCopula * build(const NumericalPointCollection & parameters) const;
  NormalCopula * build() const;


}; /* class NormalCopulaFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_NORMALCOPULAFACTORY_HXX */
