//                                               -*- C++ -*-
/**
 *  @file  PolynomialKernel.hxx
 *  @brief Implementation of the polynomial kernel
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: PolynomialKernel.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_POLYNOMIALKERNEL_HXX
#define OPENTURNS_POLYNOMIALKERNEL_HXX

#include "SVMKernelImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class PolynomialKernel
 *
 * Implementation of the polynomial kernel
 */



class PolynomialKernel
  : public SVMKernelImplementation
{
  CLASSNAME;
public:


  /** Constructor with parameters */
  PolynomialKernel(const NumericalScalar degree = 3.0, const NumericalScalar linear = 1.0, const NumericalScalar constant = 0.0);

  /** Virtual constructor */
  virtual PolynomialKernel * clone() const;

  /** String converter */
  virtual String __repr__() const;

  /** Degree accessor */
  virtual NumericalScalar getDegree() const;
  virtual void setDegree(NumericalScalar degree);

  /** Linear term accessor */
  virtual NumericalScalar getLinear() const;
  virtual void setLinear(NumericalScalar linear);

  /** Constant term accessor */
  virtual NumericalScalar getConstant() const;
  virtual void setConstant(NumericalScalar constant);

  /** Accessor to the parameter used for cross-validation */
  virtual NumericalScalar getParameter() const;
  virtual void setParameter(NumericalScalar value);

  /** Parameters value and description accessor */
  virtual NumericalPointWithDescription getParameters() const;
  virtual void setParameters(const NumericalPointWithDescription & parameters);

  /** Operator () */
  virtual NumericalScalar operator() (const NumericalPoint & x1, const NumericalPoint & x2) const;

  /** Partial gradient */
  virtual NumericalPoint partialGradient(const NumericalPoint & x1, const NumericalPoint & x2) const;

  /** Partial hessian */
  virtual SymmetricMatrix partialHessian(const NumericalPoint & x1, const NumericalPoint & x2) const;

protected:
  NumericalScalar degree_;
  NumericalScalar linear_;
  NumericalScalar constant_;
private:

} ; /* class PolynomialKernel */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_POLYNOMIALKERNEL_HXX */
