//                                               -*- C++ -*-
/**
 *  @file  Factorial.hxx
 *  @brief Factorial experiment plane
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: Factorial.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_FACTORIAL_HXX
#define OPENTURNS_FACTORIAL_HXX

#include "OTprivate.hxx"
#include "StratifiedExperiment.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class Factorial
 *
 * The class describes the probabilistic concept of factorial experiment plan
 */
class Factorial
  : public StratifiedExperiment
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit Factorial(const String & name = DefaultName);

  /** Constructor with parameters */
  explicit Factorial(const NumericalPoint & center,
                     const NumericalPoint & levels,
                     const String & name = DefaultName);

  /** Constructor with parameters */
  explicit Factorial(const UnsignedLong dimension,
                     const NumericalPoint & levels,
                     const String & name = DefaultName);

  /** Virtual constructor */
  virtual Factorial * clone() const;

  /** Experiment plane generation */
  virtual NumericalSample generate();

  /** String converter */
  virtual String __repr__() const;

}; /* class Factorial */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_FACTORIAL_HXX */
