//                                               -*- C++ -*-
/**
 *  @file  LeastSquaresMetaModelSelectionFactory.hxx
 *  @brief A factory for building LeastSquaresMetaModelSelection objects
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: LeastSquaresMetaModelSelectionFactory.hxx 1649 2010-11-09 12:44:00Z dutka $
 */
#ifndef OPENTURNS_LEASTSQUARESMETAMODELSELECTIONFACTORY_HXX
#define OPENTURNS_LEASTSQUARESMETAMODELSELECTIONFACTORY_HXX

#include "NumericalSample.hxx"
#include "ApproximationAlgorithmImplementationFactory.hxx"
#include "LeastSquaresMetaModelSelection.hxx"
#include "BasisSequenceFactory.hxx"
#include "CorrectedLeaveOneOut.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class LeastSquaresMetaModelSelectionFactory
 *
 * A factory for building LeastSquaresMetaModelSelection objects
 */
class LeastSquaresMetaModelSelectionFactory
  : public ApproximationAlgorithmImplementationFactory
{
  CLASSNAME;
public:

  /** Constructor */
  LeastSquaresMetaModelSelectionFactory(const BasisSequenceFactory & fact = LAR(),
                                        const FittingAlgorithm & algo = CorrectedLeaveOneOut());

  /** Virtual constructor */
  LeastSquaresMetaModelSelectionFactory * clone() const;

  /** Accessors */
  BasisSequenceFactory getBasisSequenceFactory() const;
  FittingAlgorithm getFittingAlgorithm() const;

  /** Method to create new LeastSquaresMetaModelSelection objects */
  virtual LeastSquaresMetaModelSelection * build(const NumericalSample & x,
                                                 const NumericalSample & y,
                                                 const NumericalPoint & weight,
                                                 const Basis & psi) const;
  /** String converter */
  virtual String __repr__() const;

  /** Method save() stores the object through the StorageManager */
  virtual void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  virtual void load(Advocate & adv);

private:
  /** The algorithm that generates a family of basis */
  BasisSequenceFactory basisSequenceFactory_;

  /** The cross-validation algorithm */
  FittingAlgorithm fittingAlgorithm_;


}; /* class LeastSquaresMetaModelSelectionFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_LEASTSQUARESMETAMODELSELECTIONFACTORY_HXX */
