//                                               -*- C++ -*-
/**
 *  @file  OrthonormalizationAlgorithm.hxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-09-14 14:39:35 +0200 (lun. 14 sept. 2009) $
 *  Id:      $Id: OrthonormalizationAlgorithm.hxx 1331 2009-09-14 12:39:35Z dutka $
 */
#ifndef OPENTURNS_ORTHONORMALIZATIONALGORITHM_HXX
#define OPENTURNS_ORTHONORMALIZATIONALGORITHM_HXX

#include "OrthonormalizationAlgorithmImplementation.hxx"
#include "Pointer.hxx"
#include "TypedInterfaceObject.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class OrthonormalizationAlgorithm
       */

      class OrthonormalizationAlgorithm
	: public Base::Common::TypedInterfaceObject<OrthonormalizationAlgorithmImplementation>
      {
	CLASSNAME;

      public:
	typedef Base::Common::Pointer<OrthonormalizationAlgorithmImplementation> Implementation;
	typedef OrthonormalizationAlgorithmImplementation::Distribution          Distribution;
	typedef OrthonormalizationAlgorithmImplementation::Coefficients          Coefficients;

	/** Constructor with parameters */
	OrthonormalizationAlgorithm(const OrthonormalizationAlgorithmImplementation & implementation);

	/** Constructor with parameters */
	OrthonormalizationAlgorithm(Implementation & p_implementation);

	/** Constructor with parameters */
	OrthonormalizationAlgorithm(const Distribution & measure);

	/** Default Constructor */
	explicit OrthonormalizationAlgorithm();

        /** Calculate the coefficients of recurrence a0, a1, a2 such that
            Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
        Coefficients getRecurrenceCoefficients(const UnsignedLong n) const;

	/** Measure accessor */
	Distribution getMeasure() const;
	void setMeasure(const Distribution & measure);

	/** String converter */
	String __repr__() const;

	/** String converter */
	String __str__() const;

      } ; /* class OrthonormalizationAlgorithm */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHONORMALIZATIONALGORITHM_HXX */
