//                                               -*- C++ -*-
/**
 *  @file		LowDiscrepancySequence.hxx
 *  @brief	Interface for low discrepancy sequences
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */
#ifndef OPENTURNS_LOWDISCREPANCYSEQUENCE_HXX
#define OPENTURNS_LOWDISCREPANCYSEQUENCE_HXX

#include "LowDiscrepancySequenceImplementation.hxx"
#include "Pointer.hxx"
#include "TypedInterfaceObject.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {
      /**
       * @class LowDiscrepancySequence
       */

      class LowDiscrepancySequence :
	public Base::Common::TypedInterfaceObject<LowDiscrepancySequenceImplementation>
      {
	CLASSNAME;

      public:
	typedef LowDiscrepancySequenceImplementation::NumericalPoint  NumericalPoint;
	typedef Common::InvalidArgumentException	              InvalidArgumentException;
	typedef Common::Pointer<LowDiscrepancySequenceImplementation> Implementation;

	/** Default constructor */
	explicit LowDiscrepancySequence();

	/** Constructor with parameters*/
	explicit LowDiscrepancySequence(const UnsignedLong dimension);

	/** Constructor with parameters */
	LowDiscrepancySequence(const LowDiscrepancySequenceImplementation & implementation);

	/** Constructor with parameters */
	LowDiscrepancySequence(Implementation & p_implementation);

	/** Initialize the sequence */
	void initialize(const UnsignedLong dimension);

	/** Dimension accessor */
	UnsignedLong getDimension() const;

	/** Generate a quasi-random vector of numbers uniformly distributed over [0, 1) */
	NumericalPoint generate();

	/** Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1) */
	NumericalSample generate(const UnsignedLong size);

	/** Compute the star discrepancy of a sample uniformly distributed over [0, 1) */
	NumericalScalar computeStarDiscrepancy(const NumericalSample & sample) const;

	/** String converter */
	String __repr__() const;

      }; /* class LowDiscrepancySequence */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOWDISCREPANCYSEQUENCE_HXX */
