/*
 * openser osp module. 
 *
 * This module enables openser to communicate with an Open Settlement 
 * Protocol (OSP) server.  The Open Settlement Protocol is an ETSI 
 * defined standard for Inter-Domain VoIP pricing, authorization
 * and usage exchange.  The technical specifications for OSP 
 * (ETSI TS 101 321 V4.1.1) are available at www.etsi.org.
 *
 * Uli Abend was the original contributor to this module.
 * 
 * Copyright (C) 2001-2005 Fhg Fokus
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */





#include "osp/ospprovider.h"

char* _spURIs[2];
unsigned long _spWeights[2]       = {1000,1000};
unsigned char* _private_key       = NULL;
unsigned char* _local_certificate = NULL;
unsigned char* _ca_certificate    = NULL;
char* _device_ip         = NULL;
char* _device_port       = NULL;
int   _ssl_lifetime      = 300;
int   _persistence       = 60 * 1000;
int   _retry_delay       = 0;
int   _retry_limit       = 2;
int   _timeout           = 60 * 1000;
int   _max_destinations  = 5;
int   _token_format      = 2;
int   _crypto_hw_support = 0;
/* by default validate call ids, set to 0 to disable validation */
int   _validate_call_id  = 1;
char _PRIVATE_KEY[255];
char _LOCAL_CERTIFICATE[255];
char _CA_CERTIFICATE[255];

OSPTPROVHANDLE _provider = -1;
