/**********************************************************************
 *
 *	FILE:			Switch.cpp
 *
 *	DESCRIPTION:	Read/Write osg::Switch in binary format to disk.
 *
 *	CREATED BY:		Auto generated by iveGenerator
 *					and later modified by Rune Schmidt Jensen.
 *
 *	HISTORY:		Created 9.4.2003
 *
 *	Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "MultiSwitch.h"
#include "Group.h"

using namespace ive;

void MultiSwitch::write(DataOutputStream* out){
	// Write Switch's identification.
	out->writeInt(IVEMULTISWITCH);
	// If the osg class is inherited by any other class we should also write this to file.
	osg::Group*  group = dynamic_cast<osg::Group*>(this);
	if(group){
		((ive::Group*)(group))->write(out);
	}
	else
		throw Exception("Switch::write(): Could not cast this osg::Switch to an osg::Group.");
	// Write Switch's properties.

        out->writeBool(getNewChildDefaultValue());
        out->writeUInt(getActiveSwitchSet());

        const osgSim::MultiSwitch::SwitchSetList& switchset = getSwitchSetList();
        out->writeUInt(switchset.size());
        for(unsigned int s=0;s<switchset.size();++s)
        {
	    // Write childrens value.
	    for(unsigned int i=0; i<getNumChildren();i++)
            out->writeBool(getValue(s,i));
        }
}

void MultiSwitch::read(DataInputStream* in){
	// Peek on Switch's identification.
	int id = in->peekInt();
	if(id == IVEMULTISWITCH){
		// Read Switch's identification.
		id = in->readInt();
		// If the osg class is inherited by any other class we should also read this from file.
		osg::Group*  group = dynamic_cast<osg::Group*>(this);
		if(group){
			((ive::Group*)(group))->read(in);
		}
		else
			throw Exception("Switch::read(): Could not cast this osg::Switch to an osg::Group.");
		// Read Switch's properties

                setNewChildDefaultValue(in->readBool());
                setActiveSwitchSet(in->readUInt());

                unsigned int numSwitchSets = in->readUInt();
                
                for(unsigned int s=0;s<numSwitchSets;++s)
                {
                    // Read childrens value.
		    for(unsigned int i=0; i<getNumChildren();i++)
			    setValue(s, i, in->readBool());
                }
	}
	else{
		throw Exception("Switch::read(): Expected Switch identification.");
	}
}
