/**********************************************************************
 *
 *    FILE:            ElevationSector.cpp
 *
 *    DESCRIPTION:    Read/Write osgSim::ElevationSector in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator.exe
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 9.9.2003
 *
 **********************************************************************/

#include "Exception.h"
#include "ElevationSector.h"

using namespace ive;

void ElevationSector::write(DataOutputStream* out){
    // Write ElevationSector's identification.
    out->writeInt(IVEELEVATIONSECTOR);
    // Write ElevationSector's properties.
    out->writeFloat(getMinElevation());
    out->writeFloat(getMaxElevation());
    out->writeFloat(getFadeAngle());
}

void ElevationSector::read(DataInputStream* in){
    // Peek on ElevationSector's identification.
    int id = in->peekInt();
    if(id == IVEELEVATIONSECTOR){
        // Read ElevationSector's identification.
        id = in->readInt();
        // Read ElevationSector's properties
        float minElevation = in->readFloat();
        float maxElevation = in->readFloat();
        float fadeAngle = in->readFloat();
        setElevationRange(minElevation, maxElevation, fadeAngle);
    }
    else{
        in_THROW_EXCEPTION("ElevationSector::read(): Expected ElevationSector identification.");
    }
}
