# file: config_update.py
#
# Author: Todd Faris (Snowdog)
# Date:   5/10/2005
#
# Comparison and update functions for openrpg's main config (.ini) file
#

#----IMPORTS----
from orpg.orpg_xml import *


#----CONSTANTS----
AUTOUPDATE_KEY_NAME = "autoupdate_config"


#----------------------------------------------------------------------------------------
# UpdateIniFile()
# Orchistrates the updating of the users settings ini (ini.xml) file.
# Returns number of chances made to memory loaded tree. If non-zero the
# tree should be resaved.
#----------------------------------------------------------------------------------------
def UpdateIniFile(xml_tree,template_fq_filename):
    "Updates keys in the Openrpg user .ini file to add missing keys from a template file"
    changeMade = 0
    nodeDict = GetNodeDict(xml_tree)
    if not CheckUpdatePreference(nodeDict):
        #user config specified no auto updating.
        return changeMade
    #open the template file and make node comparisons.
    templateTree = loadTree(template_fq_filename)
    if templateTree == None:
        #this shouldn't happen but gotta be safe...
        print "WARNING: UpdateIniFile() Template Load Failed."
        return changeMade

    templateDict = GetNodeDict(templateTree)
    changeMade = MergeTrees(xml_tree, nodeDict, templateDict)
    return changeMade #returns true if changes were made


    
#----------------------------------------------------------------------------------------
# MergeTrees()
# Iterates though the template dictionary and compare to the dictionary from the users
# loaded tree. If a node is found to be missing it is added from the template to the user
# tree. For nodes that do exist their attributes are checked by calling UpdateSettings()
# The return value signals to other functions that the user tree has been updated and 
# should be resaved.
#----------------------------------------------------------------------------------------
def MergeTrees(usrTree, usrDict, templateDict):
    adds = 0
    for n in templateDict:
        if not usrDict.has_key(n):
            usrTree.appendChild(templateDict[n])
            adds += 1
        else:
            adds += UpdateSettings( usrDict[n], templateDict[n] )
        
    return adds



#----------------------------------------------------------------------------------------
# UpdateSettings()
# Iterates over the static attributes of a node that all settings nodes should have.
# If one of the settings is different (perhaps updated help info, or a catagory was
# changed by a developer) the value from the template file is used to replace the users.
#
# WARNING: the 'value' attribute is never modified. Doing so would bash the users settings.
#----------------------------------------------------------------------------------------
def UpdateSettings(userNode, templateNode):
    changed = 0
    attribs = ["catagory","help","options"]
    for a in attribs:
        try:
            u = userNode.getAttribute(a)
            t = templateNode.getAttribute(a)
            if not u == t:
                #update the attribute from the template file
                userNode.setAttribute(a,t)
                changed += 1
        except:
            pass #ignore any errors in setting verification.
    return changed
                
                

#----------------------------------------------------------------------------------------
# GetNodeDict()
# creates a dictionary that references the various Node names in a tree
# This allows for simple iteration over the tree leaf/branch in other functions
#
# NOTE: There is a chance that duplicated nodes (same name) will be hidden in the dictionary
# but being as there shouldn't be duplicates anyway it probably doesn't matter much. -- SD
#----------------------------------------------------------------------------------------
def GetNodeDict(xml_tree):
    "constructs a dictionary of node references"
    node_list = xml_tree._get_childNodes()
    dict = {}
    for n in node_list:
        dict[n._get_tagName()] = n
    return dict


#----------------------------------------------------------------------------------------
# CheckUpdatePreference()
# Checks the loaded users tree for the presence of the AUTOUPDATE_KEY_NAME node.
# If it exists it uses the users preference to decide to run auto-update functions
# If the node doesn't exist it requests auto-update run so the key can be added
# (assuming the template file has the node in it)
#----------------------------------------------------------------------------------------
def CheckUpdatePreference(nodeDict):
    "Check a loaded orpg config tree for the presence and value of the auto-config property"
    should_check = False
    if nodeDict.has_key(AUTOUPDATE_KEY_NAME):
        usr_pref = (nodeDict[AUTOUPDATE_KEY_NAME]).getAttribute("value")
        if usr_pref == "0":
            return False
    return True




#----------------------------------------------------------------------------------------
# loadTree function duplicated from orpg_settings.py
# simpler to duplicate this small bit of code than import
# its container settings class and instance it.
#----------------------------------------------------------------------------------------
def loadTree(filename):
    try:
        ini = open(filename,"r")
        txt = ini.read()
        tree = parseXml(txt)._get_documentElement()
        ini.close()
        return tree
    except:
        return None
