# This class implements the basic chat commands available in the chat interface.
#
# Defines:
#   __init__(self,chat)
#   docmd(self,text)
#   on_help(self)
#   on_whisper(self,text)
#


import string
import time
import orpg.tools.orpg_update
import orpg.orpg_version
import orpg.orpg_windows
import orpg.plugins#mDuo13 added
import traceback

##--------------------------------------------------------------
## dynamically loading module for extended developer commands
## allows developers to work on new chat commands without
## integrating them directly into the ORPG code allowing
## updating of their code without merging changes
## cmd_ext.py should NOT be included in the CVS or Actual Releases

try:
    import cmd_ext
    print "Importing Developer Extended Command Set"
except:
    pass
##----------------------------------------------------------------

ANTI_LOG_CHAR = '!'

class chat_commands:

    # Initialization subroutine.
    #
    # !self : instance of self
    # !chat : instance of the chat window to write to
    def __init__(self,chat):
        self.post = chat.Post
        self.colorize = chat.colorize
        self.session = chat.session
        #self.send = chat.session.send
        self.settings = chat.settings
        self.chat = chat
        # def __init__ - end
        self.previous_whisper = []


        # This subroutine will take a text string and attempt to match to a series
        # of implemented emotions.
        #
        # !self : instance of self
        # !text : string of text matching an implemented emotion
    def docmd(self,text):
        cmdlist = string.split(text,None,1)
        cmd = string.lower(cmdlist[0])
        num_cmds = len(cmdlist)
        #print "cmdlist is %s" % cmdlist
        if cmd == "/version":
            self.chat.InfoPost("Version is OpenRPG " + self.chat.version)
            print "/version is %s" % self.chat.version
        elif cmd == "/help": ## put a test for a second word in here...
            self.on_help()
        ## use for /me
        elif cmd == "/me" or cmd == "/he" or cmd == "/she":
            if len(cmdlist) > 1:
                # Colorize the basic text based on our emote color
                self.chat.emote_message(cmdlist[1])

                #text = "<font color=\"%s\">%s</font>" % (self.chat.emotecolor, cmdlist[1])

                # Colorize our name to match our text color
                #namesame = self.settings.get_setting('NameSameEmoteColor')
                #namesame = namesame.lower()
                #if namesame == "yes" or namesame=="y" or namesame == "1":
                #    nameColor = "<font color=\"" + self.chat.emotecolor + "\"> %s </font> " % self.session.name
                #else:
                #    nameColor = "<font color=\"" + self.chat.mytextcolor + "\"> %s </font> " % self.session.name

                # Replace ALL emotes found...not just the ones at the beginning of the line!
                #if text.find( "/she" ) > -1: text = text.replace( "/she", nameColor )
                #if text.find( "/he" ) > -1: text = text.replace( "/he", nameColor )
                #if text.find( "/me" ) > -1: text = text.replace( "/me", nameColor )

                # Now, properly colorize the whole string using the emote color for local display
                #postMsg = "<font color=\"%s\">** %s %s **</font>" % ( self.chat.emotecolor,
                #                                                   nameColor, text )
                #self.chat.Post( postMsg )

                ## We now use the /me as just a prefix for the remote end to expand our name.
                ## Required to prevent spoofing on emotes!
                #text = "<font color=\"%s\"> %s</font>" % ( self.chat.mytextcolor, text )
                #self.session.send( ("/me" + text) )

            else:
                self.chat.InfoPost("(It's always all about you, isn't it?  No text to emote was provided!)")

            # emote for ignoring
        elif cmd == "/i" or cmd == "/ignore":
            try:
                self.on_ignore(cmdlist[1])
            except:
                self.on_ignore("")
        # emote for whispering
        elif cmd == "/lines":
            try:
                self.on_lines(cmdlist[1])
            except:
                self.on_lines("0")

        elif cmd == "/load":
            try:
                self.settings.setup_ini(cmdlist[1])
                self.settings.reload_settings(self.chat)
                self.chat.InfoPost("Settings Loaded from file " + cmdlist[1] )
            except Exception,e:
                print e
                self.chat.InfoPost("ERROR Loading settings")

        elif cmd =="/purge":
                self.chat.Purge_buffer()

        elif cmd == "/role":
            try:
                self.on_role(cmdlist[1])
            except:
                self.on_role("")

        elif cmd == "/font":
            try:
                fontsettings = self.chat.set_default_font(fontname=cmdlist[1], fontsize=None)
                #self.chat.InfoPost("Font is now " + fontsettings[0] + " point size " + `fontsettings[1]`)
            except:
                self.chat.InfoPost("ERROR setting default font")

        elif cmd == "/fontsize":
            try:
                fontsettings = self.chat.set_default_font(fontname=None, fontsize=int(cmdlist[1]))
                #self.chat.InfoPost("Font is now " + fontsettings[0] + " point size " + `fontsettings[1]`)
            except Exception, e:
                print e
                self.chat.InfoPost("ERROR setting default font size")

        elif cmd == "/close":
            try:
              chatpanel = self.chat
              if (chatpanel.sendtarget == "all"):
                chatpanel.InfoPost("Error:  cannot close public chat tab.")
              else:
                chatpanel.chat_timer.Stop()
                chatpanel.parent.destroy_private_tab(chatpanel)
            except:
              self.chat.InfoPost("Error:  cannot close private chat tab.")

        elif cmd == "/set":
            self.on_set(cmdlist)

        elif cmd == "/w" or cmd == "/whisper":
            self.on_whisper(cmdlist[1])

        #Group Whisper command
        elif cmd == "/gw":
            self.on_groupwhisper(cmdlist[1])

        #GM Whisper command
        elif cmd == "/gmw" or cmd == "/gm":
            self.on_gmwhisper(cmdlist[1])

        # emote for changing name
        elif cmd == "/name" or cmd == "/nick":
            try:
                self.on_name(cmdlist[1])
            except:
                self.on_name("")
        # emot for changing status
        elif cmd == "/date" or cmd == "/time":
            local_time = time.localtime()
            gmt_time = time.gmtime()
            format_string = "%A %b %d, %Y  %I:%M:%S%p"
            self.chat.InfoPost("<br>Local: " + time.strftime(format_string)+\
                               "<br>GMT: "+time.strftime(format_string,gmt_time))
        elif cmd == "/status":
            try:
                self.on_status(cmdlist[1])
            except:
                self.on_status("")

        # emot for changing status
        elif cmd == "/dieroller":
            rm = self.chat.roller_manager
            try:
                rm.set_roller(cmdlist[1])
                self.chat.SystemPost("You have changed your die roller to the <b>\"" + cmdlist[1] + "\"</b> roller.")
                self.settings.set_setting('dieroller',cmdlist[1])
            except Exception, e:
                print e
                self.chat.InfoPost("Available die rollers: " + str(rm.get_rollers()))
                self.chat.InfoPost("You are using the <b>\"" + rm.get_roller() + "\"</b> die roller.")

        elif cmd == "/log":
            self.on_log(cmdlist)

        elif cmd == "/update":
            if num_cmds == 1:
                self.on_update("release")
            elif num_cmds == 2:
                self.on_update(cmdlist[1])
        elif cmd == "/moderate":
            if (len(cmdlist)>1):
                self.on_moderate(cmdlist[1])
            else:
                self.on_moderate("")
        elif cmd == "/tab":
            if (len(cmdlist)>1):
                self.invoke_tab(cmdlist[1])
            else:
                self.chat.InfoPost(" ** Invalid ID to Spawn Whisper Tab")

        # ping command altered by Snowdog 8/03
        # now sends time data to be returned by server
        elif cmd == "/ping":
            ct = time.clock()
            msg = "<ping player='"+self.session.id+"' time='"+str(ct)+"' />"
            self.session.outbox.put(msg)
        elif cmd == "/admin":
            #remote administration commands.
            self.on_remote_admin(cmdlist)
        elif cmd == "/d" or cmd == "/desc":
            if len(cmdlist) > 1:
                self.on_description(cmdlist[1])
            else:
                self.chat.InfoPost(" ** Format: /d &lt; line of descriptive text &gt;")

        else:
            ## attempt to access the extended command file if present
            ## if it fails command will simply be 'unknown' --snowdog
            try:
                if cmd_ext.process( self, cmd, cmdlist ):
                    return
            except:
                pass
            #following added by mDuo13. (Plugin code)
            a=0
            #plugins
            for plugin_fname in orpg.plugins.frame.enabled_plugins.keys():
                plugin = orpg.plugins.frame.enabled_plugins[plugin_fname]
                try:
                    a+=plugin.docmd(self,text,cmdlist)
                except Exception, e:
                    if str(e) != "'module' object has no attribute 'docmd'":
                        #print e
                        traceback.print_exc()
            if a==0:
                #end mDuo13 added code
                #following line tabbed in by mDuo13
                self.chat.InfoPost(" ** Sorry, don't understand what a " + cmdlist[0] + " is...")

    def on_log(self,cmdlist):
        logfile = self.settings.get_setting( 'GameLogPrefix' )
        cmdlist = string.split( string.join( cmdlist, ' ' ), ' ')
        if len( cmdlist ) == 1:
            self.postLoggingState()
        elif cmdlist[1] == "on" and logfile != '':
            try:
                while logfile[ 0 ] == ANTI_LOG_CHAR:
                    print logfile
                    logfile = logfile[ 1: ]
            except IndexError,e:
                self.chat.SystemPost("log filename is blank, system will *not* be logging until a valid filename is specified" )
                self.settings.set_setting( 'GameLogPrefix', logfile )
                return
            self.settings.set_setting( 'GameLogPrefix', logfile )
            self.postLoggingState()
        elif cmdlist[1] == "off":
            logfile = ANTI_LOG_CHAR+logfile
            self.settings.set_setting( 'GameLogPrefix', logfile )
            self.postLoggingState()
        elif cmdlist[1] == "to":
            if len( cmdlist ) > 2:
                logfile = cmdlist[2]
                self.settings.set_setting( 'GameLogPrefix', logfile )
            else:
                self.chat.SystemPost('You must also specify a filename with the <em>/log to</em> command.' )
            self.postLoggingState()
        else:
            self.chat.InfoPost("Unknown logging command, use 'on' or 'off'"  )

    def on_lines(self,cmd):
        if int(str(cmd))>0:
            self.settings.set_setting('buffersize',cmd)
            self.chat.SystemPost("Maximum number of lines in chat now set to "+cmd)
            self.chat.on_buffer_size(cmd)
        else:
            self.chat.SystemPost("Maximum lines in chat: "+self.settings.get_setting("buffersize"))
            self.chat.Post()

    def postLoggingState( self ):
        logfile = self.settings.get_setting( 'GameLogPrefix' )
        try:
            if logfile[0] != ANTI_LOG_CHAR:
                comment = 'is'
            else:
                comment = 'is not'
        except:
            comment = 'is not'
        suffix = time.strftime( '-%d-%m-%y.html', time.localtime( time.time() ) )
        self.chat.InfoPost('Log filename is "%s%s", system is %s logging.' % (logfile, suffix, comment) )

        # This subroutine will set the players netork status.
        #
        #!self : instance of self

    def on_name(self,txt):
        #only 20 chars no more! :)
        if txt == "":
            self.chat.InfoPost("**Incorrect syntax for name.")
        else:
            #txt = txt[:50]
            self.settings.set_setting('player',txt)
            self.session.set_name(txt)
    # def on_status - end

        # This subroutine will set the players netork status.
        #
        # !self : instance of self
    def on_status(self,txt):
        if txt ==  "":
            self.chat.InfoPost("Incorrect synatx for status.")
        else:
        #only 20 chars no more! :)
            txt = txt[:20]
            self.session.set_text_status(txt)
    # def on_status - end

    def on_set(self,cmdlist):
        keys = self.settings.get_setting_keys()
        if len(cmdlist) == 1:
            line = "<table border='2'>"
            for m in range(len(keys)):
                line += "<tr><td>" + keys[m] + "</td><td> " + self.settings.get_setting(keys[m]) + "</td></tr>"
            line += "</table>"
            self.chat.InfoPost(line)
        else:
            split_name_from_data = cmdlist[1].find("=")
            if split_name_from_data == -1:
                for m in keys:
                    if m == cmdlist[1]:
                        return_string = "<table border='2'><tr><td>" + cmdlist[1] + "</td><td>"\
                        + self.settings.get_setting(cmdlist[1]) + "</td></tr></table>"
                        self.chat.InfoPost(return_string)
            else:
                name=cmdlist[1][:split_name_from_data].strip()
                for m in keys:
                    if m == name:
                        setting=cmdlist[1][split_name_from_data+1:].strip()
                        self.settings.set_setting(name,setting)
                        return_string = name + " changed to " + setting
                        self.chat.InfoPost(return_string)
                        self.session.set_name(self.settings.get_setting("player"))
                        self.chat.set_colors()
                        self.chat.set_buffersize()

        # This subroutine will display the correct usage of the different emotions.
        #
        #!self : instance of self

    def on_help(self):
        self.chat.InfoPost("<br>Emote commands:")
        text =  self.colorize( self.chat.infocolor, "/date" ) +\
                " - Display the local and GMT time and date."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/dieroller roller" ) + \
                " - Set your dieroller or list the available rollers."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/font <fontname>" ) + \
                " - Sets the font."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/fontsize <size>" ) + \
                " - Sets the size of your fonts.  Recomended 8 or better for the size."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor,"/help") + \
                " - Displays a list of emote commands."
        self.chat.Post(text)

        text =  self.colorize(self.chat.infocolor, "/i or /i player_id_number") +\
                " - Ignore user associated with that player ID."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/lines [number]") +\
                " - View or set the maximum number of lines shown in chat."
        self.chat.Post(text)
        text = self.colorize(self.chat.infocolor,"/load <filename>") + \
               " - Loads settings from another ini file from the myfiles directory."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/log [ on | off | to <em>filename</em> ]" ) + \
                " - Check log state, additionally turn logging on, off, or set the log filename prefix."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor,"/me") + \
                " - Alias for **yourname."
        self.chat.Post(text)
        text = self.colorize( self.chat.infocolor, "/moderate [ on | off ]") + \
               " - Show who can speak in a moderated room, or turn room moderation on or off."
        self.chat.Post(text)
        text = self.colorize( self.chat.infocolor, "/moderate player_id,...=on | off") + \
               " - Give people the ability to speak in a moderated room, or revoke it."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor, "/name or /nick your_name")+\
                " - Change your name."
        self.chat.Post(text)
        text = self.colorize(self.chat.infocolor, "/ping") +\
               " - Ask for a response from the server."
        self.chat.Post(text)
        text = self.colorize( self.chat.infocolor,"/purge") +\
               " - Purge history older than your buffersize."
        self.chat.Post(text)
        text = self.colorize( self.chat.infocolor, "/role [player_id = GM | Player | Lurker]") + \
                " - Get player roles from ther server, or change the role of a player."
        self.chat.Post(text)
        text = self.colorize( self.chat.infocolor, "/set [setting[=value]]") + \
                " - Displays one or all settings, or sets a setting."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor, "/status your_status") +\
                " - Set your online status (afk,away,etc..)."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/time" ) +\
                " - See /date."
        self.chat.Post(text)
        text =  self.colorize( self.chat.infocolor, "/update [get]" ) + \
                " - Get the latest version of OpenRPG."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor,"/version") + \
                " - Displays current version of OpenRPG."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor, "/w player_id_number, ... = message") +\
                " - Whisper to player(s). Can contain multiple IDs."
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor, "/gw [group_name]=message") +\
                " - Type /gw help for more information"
        self.chat.Post(text)
        text =  self.colorize(self.chat.infocolor, "/gm  message") +\
                " - Whispers to all GMs in the room"
        self.chat.Post(text)

        # This subroutine will either show the list of currently ignored users
        # !self : instance of self
        # !text : string that is comprised of a list of users to toggle the ignore flag


    def on_ignore(self,text):
        (ignore_list, ignore_name) = self.session.get_ignore_list()
        ignore_output = self.colorize(self.chat.syscolor,"<br><u>Player IDs Currently being Ignored:</u><br>")
        if text == "":
            if len(ignore_list) == 0:
                ignore_output += self.colorize(self.chat.infocolor,"No players are currently being ignored.<br>")
            else:
                for m in ignore_list:
                    ignore_txt = m + " " + ignore_name[ignore_list.index(m)] + "<br>"
                    ignore_output += self.colorize(self.chat.infocolor,ignore_txt)
            self.chat.Post(ignore_output)
        else:
            players = text.split(",")
            for m in players:
                try:
                    id = `int(m)`
                    (result, id, name) =self.session.toggle_ignore(id)
                    if result == 0:
                        self.chat.Post(self.chat.colorize(self.chat.syscolor, "Player " + name + " with ID:" + id + " no longer ignored"))
                    if result == 1:
                        self.chat.Post(self.chat.colorize(self.chat.syscolor, "Player " + name + " with ID:" + id + " now being ignored"))
                except:
                    self.chat.Post(self.colorize(self.chat.syscolor, m + " was ignored because it is an invalid player ID"))

    def on_role(self,text):
        if text == "":
            return
        delim = text.find("=")
        if delim < 0:
            self.chat.InfoPost("**Incorrect synatax for Role." + str(delim))
            return
        player_ids = string.split(text[:delim],",")
        role = text[delim+1:].strip()
        role = role.lower()
        if (role.lower() == "player") or (role.lower() == "gm") or (role.lower() == "lurker"):
            if role.lower() == "player": role = "Player"
            elif role.lower() == "gm":   role = "GM"
            else: role = "Lurker"

            #role_pwd_dialog = orpg.orpg_windows.wxTextEntryDialog(self.chat,"Enter Administrator Password:","Administrator Password")
            #if role_pwd_dialog.ShowModal() == orpg.orpg_windows.wxID_OK:
            #    role_pwd = role_pwd_dialog.GetValue()
            try:
                role_pwd = self.session.orpgFrame_callback.password_manager.GetPassword("admin",int(self.session.group_id))
                if role_pwd != None:
                    for m in player_ids:
                        self.session.set_role(m.strip(),role,role_pwd)
            except:
                traceback.print_exc()

        # This subroutine implements the whisper functionality that enables a user
        # to whisper to another user.
        #
        # !self : instance of self
        # !text : string that is comprised of a list of users and the message to
        #whisper.


    def on_whisper(self, text):
        delim = text.find("=")

        if delim < 0:
             if self.previous_whisper:
                 player_ids = self.previous_whisper
             else:
                self.chat.InfoPost("**Incorrect syntax for whisper." + str(delim))
                return
        else:
            player_ids = string.split(text[:delim], ",")
        self.previous_whisper = player_ids
        mesg = string.strip(text[delim+1:])
        self.chat.whisper_to_players(mesg,player_ids)

#---------------------------------------------------------
# [START] Digitalxero Multi Whisper Group 1/1/05
#---------------------------------------------------------
    def on_groupwhisper(self, txt):
        commands = txt.split(" ")
        delim = txt.find("=")

        if delim > 0:
            group_ids = string.split(txt[:delim], ",")
        elif commands[0] == "add":
            if not orpg.player_list.WG_LIST.has_key(commands[2]):
                orpg.player_list.WG_LIST[commands[2]] = {}
            orpg.player_list.WG_LIST[commands[2]][int(commands[1])] = int(commands[1])
            return
        elif commands[0] == "remove" or commands[0] == "delete":
            del orpg.player_list.WG_LIST[commands[2]][int(commands[1])]
            if len(orpg.player_list.WG_LIST[commands[2]]) == 0:
                del orpg.player_list.WG_LIST[commands[2]]
            return
        elif commands[0] == "create" or commands[0] == "new_group":
            if not orpg.player_list.WG_LIST.has_key(commands[1]):
                orpg.player_list.WG_LIST[commands[1]] = {}
            return
        elif commands[0] == "list":
            for n in orpg.player_list.WG_LIST[commands[1]]:
                player = self.session.get_player_info(str(n))
                self.chat.InfoPost(str(player[0]))
            return
        elif commands[0] == "clear":
            orpg.player_list.WG_LIST[commands[1]].clear()
        elif commands[0] == "clearall":
            orpg.player_list.WG_LIST.clear()
            return
        else:
            self.chat.InfoPost("/gw add [player_id] [group_name] - Adds [player_id] to [group_name]")
            self.chat.InfoPost("/gw remove [player_id] [group_name] - Removes [player_id] from [group_name]")
            self.chat.InfoPost("/gw [group_name]=[message] - Sends [message] to [group_name]")
            self.chat.InfoPost("/gw create [group_name] - Creates a whisper group called [group_name]")
            self.chat.InfoPost("/gw list [group_name] - Lists all players in [group_name]")
            self.chat.InfoPost("/gw clear [group_name] - Removes all players from [group_name]")
            self.chat.InfoPost("/gw clearall - Removes all existing whisper groups")
            return

        msg = string.strip(txt[delim+1:])
        for gid in group_ids:
            idList = ""
            for n in orpg.player_list.WG_LIST[gid]:
                if idList == "":
                    idList = str(n)
                else:
                    idList = str(n) + ", " + idList
            self.on_whisper(idList + "=" + self.settings.get_setting("gwtext") + msg)

#---------------------------------------------------------
# [END] Digitalxero Multi Whisper Group 1/1/05
#---------------------------------------------------------

    def on_gmwhisper(self, txt):
        if txt == "":
            self.chat.InfoPost("**Incorrect syntax for GM Whisper.")
        else:
            the_gms = self.chat.get_gms()
            if len(the_gms):
                gmstring = ""
                for each_gm in the_gms:
                    if gmstring != "":
                        gmstring += ","
                    gmstring += each_gm
                self.on_whisper(gmstring+"="+txt)
            else:
                self.chat.InfoPost("**No GMs to Whisper to.")

    def on_moderate(self,text):
        if text<>"":
            pos=text.find("=")
            if (pos<0):
                plist=""
                if text.lower()=="on":
                    action="enable"
                elif text.lower()=="off":
                    action="disable"
                else:
                    self.chat.InfoPost("Wrong syntax for moderate command!")
                    return
            else:
                plist=string.strip(text[:pos])
                tag=string.strip(text[pos+1:])
                if tag.lower() == "on":
                    action="addvoice"
                elif tag.lower() == "off":
                    action="delvoice"
                else:
                    self.chat.InfoPost("Wrong syntax for moderate command!")
                    return
            pwd = self.session.orpgFrame_callback.password_manager.GetPassword("admin",int(self.session.group_id))
            if pwd != None:

            #pwd_dialog = orpg.orpg_windows.wxTextEntryDialog(self.chat,"Enter Administrator Password:","Administrator Password")
            #if pwd_dialog.ShowModal() == orpg.orpg_windows.wxID_OK:
            #    pwd = pwd_dialog.GetValue()
                msg = "<moderate"
                msg += " action='" + action + "'"
                msg +=" from='"+self.session.id+"' pwd='" +pwd + "'"
                if (plist<>""):
                    msg+=" users='"+plist+"'"
                msg += " />"
                self.session.outbox.put(msg)
            #pwd_dialog.Destroy()

            pass
        else:
            msg = "<moderate action='list' from='"+self.session.id+"' />"
            self.session.outbox.put(msg)
        self.session.update()

    def on_update(self,cmd):
        url = self.settings.get_setting( "PackagesBaseURL" )
        Disableupdate = int(self.settings.get_setting("Disableupdate" ))
        updater = orpg.tools.orpg_update.orpg_update(url,self.chat.InfoPost)
        self.chat.InfoPost("You are running " + orpg.orpg_version.VERSION + " (build "+orpg.orpg_version.BUILD+")")
        p = updater.get_package()
        self.chat.InfoPost("The latest version is " + p.getAttribute("version") + " (build "+p.getAttribute("build")+")")
        is_up2date = updater.is_up2date(orpg.orpg_version.VERSION, orpg.orpg_version.BUILD)
        if is_up2date:
            self.chat.InfoPost("OpenRPG does not require updating.")
        else:
            self.chat.SystemPost("Your code is out of date!")
            self.chat.SystemPost("Type \"/update get\" to update to the latest version.")

        if cmd=="get" and is_up2date:
            self.chat.InfoPost("OpenRPG does not require updating.")
        elif cmd=="get" and not is_up2date:
            if not Disableupdate:
                dlg = orpg.orpg_windows.do_progress_dlg(self.chat,"OpenRPG Updater","Please wait while OpenRPG upates...",3)
                dlg.Update(1,"Please wait while OpenRPG upates...")
                updater.update()
                # set the setting back so we get new gametree features
                self.settings.set_setting("LoadGameTreeFeatures","1")
                self.chat.SystemPost("Please restart OpenRPG!")
                dlg.Update(2,"Done.")
                dlg.Destroy()


    def on_description(self, text):
        if len(text) <= 0:
            self.chat.InfoPost("**No description text to display." + str(delim))
            return

        mesg = "<table bgcolor='#c0c0c0' border='3' cellpadding='5' cellspacing='0' width='100%'><tr><td><font color='#000000'>"
        mesg += string.strip(text)
        mesg += "</font></td></tr></table>"
        self.chat.Post(mesg)
        self.chat.send_chat_message(mesg)

    def invoke_tab(self, text):
        ######START mDuo13's Tab Initiator########
        playerid = text.strip()
        tabbed_whispers_p = self.settings.get_setting("tabbedwhispers")
        panelexists = 0
        if (tabbed_whispers_p == "1") and self.session.is_valid_id(playerid):
            # Check to see if parent notebook already has a private tab for player
            for panel in self.chat.parent.panel_list:
                if (panel.sendtarget == playerid):
                    self.chat.InfoPost("Cannot invoke tab: Tab already exists.")
                    return
            displaypanel = self.chat.parent.create_private_tab(playerid)

            cidx = self.chat.parent.GetSelection()
            nidx = self.chat.parent.get_tab_index(displaypanel)
            self.chat.parent.SetSelection(nidx)
            self.chat.parent.SetSelection(cidx)
            self.chat.parent.SetPageImage(nidx, self.chat.parent.chatAttentionIdx)
            return
        else:
            self.chat.Post("Cannot invoke tab: Tabbed whispering is disabled. or Invalid player ID")
            return
        #######END mDuo13's Tab Initiator#########

    def on_remote_admin(self, cmdlist):
        #handles remote administration commands
        try:
            pass_state = 0
            pwd = self.session.orpgFrame_callback.password_manager.GetSilentPassword("server")
            if  pwd != None:
                pass_state = 1
            else: pwd = "<i>[NONE]</i>"

            cmdlist = string.split( string.join( cmdlist, ' ' ), ' ')
            if len( cmdlist ) == 1:
                #raw command return state info
                msg = "<br><b>Remote Administrator Config:</b>"
                if pass_state != 1 : msg += " Password not set. Remote admin functions disabled<br>"
                else:
                    msg += " Enabled. Using password \""+pwd+"\"<br>"
                self.chat.SystemPost(msg)
                return

            if pass_state != 1 and cmdlist[1] != "set":
                #no commands under this point will execute unless an admin password has been previously set
                self.chat.SystemPost("Command ignored. No remote administrator password set!!")
                return

            msgbase = "<admin id=\""+self.session.id+"\" group_id=\""+self.session.group_id+"\" pwd=\""+pwd+"\" "

            if cmdlist[1] == "set":
                if len( cmdlist ) > 2:
                    self.session.orpgFrame_callback.password_manager.server = str( cmdlist[2] )
                    self.chat.SystemPost( "Remote administration commands using password: \""+str(self.session.orpgFrame_callback.password_manager.GetSilentPassword("server"))+"\"" )
                else:
                    pwd = self.session.orpgFrame_callback.password_manager.GetPassword("server")
                    if pwd != None:
                        self.chat.SystemPost( "Remote administration commands using password: \""+pwd+"\"" )


            elif cmdlist[1] == "help":
                #request help from server
                msg = msgbase+" cmd=\"help\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "nameroom":
                #reqest room renaming on server
                msg = msgbase+" cmd=\"nameroom\" rmid=\""+ str(cmdlist[2])+"\" name=\""+ string.join(cmdlist[3:])+"\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "roompasswords":
                #reqest room renaming on server
                msg = msgbase+" cmd=\"roompasswords\"/>"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "message":
                #send message to a specific player on the server via the system administrator
                msg = msgbase+" cmd=\"message\" to_id=\""+ str(cmdlist[2])+"\" msg=\""+ string.join(cmdlist[3:])+"\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "broadcast":
                #send a message to all players on server from the system administrator
                msg = msgbase+" cmd=\"broadcast\" msg=\""+ string.join(cmdlist[2:])+"\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "killgroup":
                #remove a group from the server and drop all players within the group
                msg = msgbase+" cmd=\"killgroup\" gid=\""+ str(cmdlist[2])+"\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "uptime":
                #request uptime report from server
                msg = msgbase+" cmd=\"uptime\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "createroom":
                #request creation of a (temporary) persistant room
                if len( cmdlist ) < 3:
                    self.chat.SystemPost( "You must supply a name and boot password at least. <br>/admin createroom &lt;name&gt; &lt;boot password&gt; [password]" )
                    return
                if len( cmdlist ) < 4:
                    self.chat.SystemPost( "You must supply a boot password also.<br>/admin createroom &lt;name&gt; &lt;boot password&gt; [password]" )
                    return
                if len( cmdlist ) < 5: cmdlist.append("")
                msg = msgbase+" cmd=\"createroom\" name=\""+str(cmdlist[2])+"\" boot=\""+ str(cmdlist[3])+"\" pass=\""+ str(cmdlist[4])+"\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "passwd":
                #request boot password change on a room
                msg = msgbase+" cmd=\"passwd\" gid=\""+str(cmdlist[2])+"\" pass=\""+ str(cmdlist[3])+"\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "list":
                #request a list of rooms and players from server
                msg = msgbase+" cmd=\"list\" />"
                self.session.outbox.put(msg)
            elif cmdlist[1] == "killserver":
                #remotely kill the server
                msg = msgbase+" cmd=\"killserver\" />"
                self.session.outbox.put(msg)
            else:
                self.chat.InfoPost("Unknown administrator command"  )
        except:
            self.chat.InfoPost("An error has occured while processing a Remote Administrator command!")
            traceback.print_exc()
