from wxPython.wx import *
from string import *
import orpg.dirpath


ID_ABOUT = wxNewId()
ID_INSTRUCTIONS = wxNewId()
ID_EXIT  = wxNewId()
ID_REFRESH = wxNewId()
ID_SEND_TO_CHAT = wxNewId()
SORT_LOW = wxNewId()
SORT_HIGH = wxNewId()
NEW_INIT = wxNewId()
END_INIT = wxNewId()
init_temp=0

class MyFrame(wxFrame):
    def __init__(self, parent, ID, title, chat,session):
        wxFrame.__init__(self, parent, ID, title,
                         wxDefaultPosition, wxSize(180, 320))


        self.chat=chat
        self.session=session
        self.init_temp=1
        #####################
        ##setting the panel
        panel = wxPanel(self, -1)




        #####################
        ##setting the text box
        self.text = wxTextCtrl(panel, 30, "   Initiative tool program",
                       wxPoint(10, 10), wxSize(150, 150), wxTE_MULTILINE)
        self.text.SetInsertionPoint(0)


        #output box (temporary)
        #self.text2 = wxTextCtrl(panel, 40, " This is here to simulate the chat window for now",
        #               wxPoint(200, 10), wxSize(150, 150), wxTE_MULTILINE)
    
        
        #####################
        ##creating the controls
        button = wxButton(panel, ID_REFRESH, "refresh")
        button.SetPosition(wxPoint(5, 230))

        button = wxButton(panel, ID_SEND_TO_CHAT, "send to chat")
        button.SetPosition(wxPoint(85, 230))

        button = wxButton(panel, SORT_LOW,  "Sort  low")
        button.SetPosition(wxPoint(5, 200))

        button = wxButton(panel, SORT_HIGH, "Sort high")
        button.SetPosition(wxPoint(85, 200))

        button = wxButton(panel, NEW_INIT, "Start Init")
        button.SetPosition(wxPoint(5, 170))

        button = wxButton(panel, END_INIT, "Keep List")
        button.SetPosition(wxPoint(85, 170))        
        #####################
        ##creating the menu
        self.CreateStatusBar()
        self.SetStatusText("Version 1.0")
        menu = wxMenu()
        menu.Append(ID_INSTRUCTIONS, "&Instructions","instructions on using the tool")
        menu.Append(ID_ABOUT, "&About","About the Init tool")
        menu.AppendSeparator()
        menu.Append(ID_EXIT, "E&xit", "Terminate the program")
        menuBar = wxMenuBar()
        menuBar.Append(menu, "&File");
        self.SetMenuBar(menuBar)


        ######################
        ##setting the events

        EVT_CLOSE(self, self.on_close)
        EVT_MENU(self, ID_EXIT,  self.on_close)
        EVT_MENU(self, ID_ABOUT, self.OnAbout)
        EVT_MENU(self, ID_INSTRUCTIONS, self.oninstructions)
        EVT_TEXT(self, 30, self.EvtText)
        EVT_BUTTON(self, ID_REFRESH, self.onrefresh)
        EVT_BUTTON(self, ID_SEND_TO_CHAT, self.onchat)
        EVT_BUTTON(self, SORT_LOW, self.onlow)
        EVT_BUTTON(self, SORT_HIGH, self.onhigh)
        EVT_BUTTON(self, NEW_INIT, self.newinit)
        EVT_BUTTON(self, END_INIT, self.endinit)
        #######################
        ##functions:


    def newinit(self, event):
        ##This clears the initlist.txt and sends the 'new init round' text to chat
        
        self.chat.Post("<hr><font color='#ff0000'>Preparing new initiative</font><br><font color='#0000ff'>Roll initiatives now</font>")
        self.session.send("<hr><font color='#ff0000'>Preparing new initiative</font><br><font color='#0000ff'>Roll initiatives now</font>")
        self.text.SetValue("")
        f=open('initlist.txt','w')
        f.write("")
        f.close()

    def endinit(self, event):


        text=self.text.GetValue()
        initline=[]
        initline=text.replace('\n','|')

        f=open(orpg.dirpath.dir_struct["user"]+'initlist.txt','w')
        f.write(initline)
        f.close()
        
        #self.chat.Post("<hr><font color='#0000ff'>End of initiative round</font><hr>")
        #self.session.send("<hr><font color='#0000ff'>End of initiative round</font><hr>")        
        #self.text.SetValue("")
        #f=open('initlist.txt','w')
        #f.write("")
        #f.close()
        

    def OnAbout(self, event):
        dlg = wxMessageDialog(self, "A special thanks to myself for \n"
                                    "doing this.  Oh, and also a big\n"
                                    "thanks to the OpenRPG Dev team\n"
                                    "for actually putting up with me\n\n-Woody",
                              "About Init tool", wxOK | wxICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def oninstructions(self, event):
        self.text.SetValue("To use the initiative tool, first press 'New init' to start a new initiative round.  Next, have all your players (and yourself) roll their initiatives by typing in \n\ninit [diceroll]\n\nNow press 'refresh' to load the list, sort it and edit it however you wish (press 'Keep list' if you want to use the same edited list later), then press 'Send to Chat' to send the person on the top of the list to the chat.  When finished it will say \n\n'(End of init)'\n\nStart a new round and repeat (if your PCs are still alive).")
                                    

    def EvtText(self, event):
        pass


    def onchat(self, event):
        from orpg.networking.mplay_client import *
        from orpg.chat.chatwnd import *
        
        text=self.text.GetValue()
        initline=[]
        temp=[]
        initline=text.split('\n')
        b=0
        print "-------initlist---------"
        print initline
        print "------------------------"
        if len(initline)==1:
            print "it equals zero"
            initline[0]="(End of init)"
        while initline[b][:1]!="(":
            initline[b]="null"
            if b != len(initline):
                b+=1
            else:
                initline[b]="(End of init)"
            
        #self.text2.SetValue(initline[b])
        #self.result=initline[b]
        self.chat.Post("<hr><font color=#ff0000>Next init</font>")
        self.session.send("<hr><font color=#ff0000>Next init</font>")
        self.chat.Post("<font color=#0000ff>"+initline[b]+"</font>")
        self.session.send("<font color=#0000ff>"+initline[b]+"</font>")

        #result=self.result
        initline[b]="null"
        self.text.SetValue("")
        for l in initline:
            if l != "null" and l !='':
                self.text.SetValue(self.text.GetValue()+l+"\n")        

        

    def onrefresh(self, event):
        self.text.SetValue("")

        f=open(orpg.dirpath.dir_struct["user"]+'initlist.txt','r')
        list=f.readline()
        list=list.split("|")
        f.close()

        for l in list:
            if l!="null" and l !='':
                self.text.SetValue(self.text.GetValue()+l+"\n")
        



    def onhigh(self, event):
        text=self.text.GetValue()
        initline=[]
        temp=[]
        initline=text.split('\n')
        initline.sort()
        initline.reverse()
        b=0
        while initline[b][:1]!="(":
            initline[b]="null"
            b+=1
       
        self.text.SetValue("")
        for l in initline:
            if l != "null" and l !='':
                self.text.SetValue(self.text.GetValue()+l+"\n")

    def onlow(self, event):
        text=self.text.GetValue()
        initline=[]
        temp=[]
        initline=text.split('\n')
        initline.sort()
        b=0
        while initline[b][:1]!="(":
            initline[b]="null"
            b+=1

        #self.text2.SetValue(initline[b])
        #initline[b]="null"
        
        self.text.SetValue("")
        for l in initline:
            if l != "null" and l !='':
                self.text.SetValue(self.text.GetValue()+l+"\n")
        
            
        
    def on_close(self, event):
        self.init_temp=0
        self.on_Destroy()
    
    def on_Destroy(self):
        #print self.init_temp
        self.Destroy()
        



#######################3
##This was just here to provide a way to test this without having to restart
##OpenRPG all the time.  Can be removed now

#class WyApp(wxApp):
#    def OnInit(self):
#        frame = MyFrame(NULL, -1, "Initiative Tool","none","none")
#        frame.Show(true)
#        self.SetTopWindow(frame)
#        self.result=result
#        return true

#wapp=WyApp(0)
#wapp.MainLoop()


