#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: orpg/mapper/grid_handler.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: grid_handler.py,v 1.8 2003/11/21 11:47:14 digitalxero Exp $
#
# Description: grid layer handler
#
__version__ = "$Id: grid_handler.py,v 1.8 2003/11/21 11:47:14 digitalxero Exp $"

from grid import *
from base_handler import *

CTRL_GRID_LINE = wxNewId()
CTRL_GRID_MODE = wxNewId()
CTRL_GRID_COLOR = wxNewId()
CTRL_GRID_SNAP = wxNewId()
CTRL_GRID_SIZE = wxNewId()
CTRL_GRID_RATIO = wxNewId()
CTRL_GRID_APPLY = wxNewId()

class grid_handler(base_layer_handler):
    def __init__(self, parent, id, canvas):
        base_layer_handler.__init__(self, parent, id, canvas)

    def build_ctrls(self):
        base_layer_handler.build_ctrls(self)

        self.line_type = wxChoice(self, CTRL_GRID_LINE, choices = ["No Lines", "Dotted Lines", "Solid Lines" ])
        #EVT_CHOICE(self, CTRL_GRID_LINE, self.on_line_type)
        self.grid_mode = wxChoice(self, CTRL_GRID_MODE, choices = ["Rectangular", "Hexagonal","Isometric"])
        self.grid_snap = wxCheckBox(self, CTRL_GRID_SNAP, " Snap")
        self.grid_size = orpgTextCtrl(self, CTRL_GRID_SIZE, size=(32,-1) )
        self.grid_ratio = orpgTextCtrl(self, CTRL_GRID_RATIO, size=(32,-1) )
        self.color_button = wxButton(self, CTRL_GRID_COLOR, "Color", style=wxBU_EXACTFIT)
        self.apply_button = wxButton(self, CTRL_GRID_APPLY, "Apply", style=wxBU_EXACTFIT)
        self.color_button.SetBackgroundColour(wxBLACK)
        self.color_button.SetForegroundColour(wxWHITE)

        #EVT_CHOICE(self, CTRL_GRID_MODE, self.on_mode)
        self.sizer.Prepend(20,25,1)
        self.sizer.Prepend(self.apply_button, 0, wxEXPAND)
        self.sizer.Prepend(10,25)
        self.sizer.Prepend(self.color_button, 0, wxEXPAND)
        self.sizer.Prepend(10,25)
        self.sizer.Prepend(self.grid_snap, 0, wxEXPAND)
        self.sizer.Prepend(3,25)
        self.sizer.Prepend(self.grid_mode, 0, wxEXPAND)
        self.sizer.Prepend(3,25)
        self.sizer.Prepend(self.line_type, 0, wxEXPAND)
        self.sizer.Prepend(3,25)
        self.sizer.Prepend(self.grid_ratio, 0, wxEXPAND)
        self.sizer.Prepend(wxStaticText(self, -1, "Ratio: "),0,wxALIGN_CENTER)
        self.sizer.Prepend(3,25)
        self.sizer.Prepend(self.grid_size, 0, wxEXPAND)
        self.sizer.Prepend(wxStaticText(self, -1, "Size: "),0,wxALIGN_CENTER)


        EVT_BUTTON(self, CTRL_GRID_COLOR, self.on_bg_color)
        EVT_BUTTON(self, CTRL_GRID_APPLY, self.on_apply)
        self.update_info()

    def update_info(self):
        layer = self.canvas.layers['grid']
        self.grid_size.SetValue(str(layer.get_unit_size()))
        self.grid_ratio.SetValue(str(layer.get_iso_ratio()))
        self.grid_mode.SetSelection(layer.get_mode())
        self.line_type.SetSelection(layer.get_line_type())
        self.color_button.SetBackgroundColour(layer.get_color())
        self.grid_snap.SetValue(layer.is_snap())

    def build_menu(self,label = "Grid"):
        base_layer_handler.build_menu(self,label)

    def on_bg_color(self,evt):
        data = wxColourData()
        data.SetChooseFull(true)
        dlg = wxColourDialog(self.canvas, data)
        if dlg.ShowModal() == wxID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            self.color_button.SetBackgroundColour(color)
        dlg.Destroy()

    def on_apply(self, evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return

        self.canvas.layers['grid'].set_grid(int(self.grid_size.GetValue()),self.grid_snap.GetValue(),
            self.color_button.GetBackgroundColour(),self.grid_mode.GetSelection(),self.line_type.GetSelection(),float(self.grid_ratio.GetValue()))
        self.update_info()
        self.canvas.send_map_data()
        self.canvas.Refresh()




