#
#    Copyright 2014, 2015 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE     = lib
TARGET       = doc-licensing
CONFIG      += staticlib
CONFIG      += c++11
CONFIG      -= debug_and_release
QT           = core

android {
	# Avoid staticlib install by undocumented behaviour of qmake
	INSTALLS     = target
	target.extra = @test -d .
}

SOURCES      = $$OUT_PWD/licensing_qrc.cpp

LICENSING_SRCS = \
  $$PWD/licensing.qdocconf \
  $$PWD/licensing-html.qdocconf \
  $$PWD/licensing.css \
  $$PWD/src/licensing.qdoc \
  $$PWD/src/gdal-licensing.qdocinc \
  $$PWD/src/qt-licensing.qdocinc \
  $$PWD/src/trademarks.qdocinc \
  $$PWD/src/apache-2.0.qdoc \
  $$PWD/src/gpl-3.0.qdoc \
  $$PWD/src/lgpl-2.1.qdoc \
  $$PWD/src/lgpl-3.0.qdoc \
  $$PWD/src/gcc-runtime-library-exception.qdoc

OTHER_FILES = \
  $$LICENSING_SRCS \
  CMakeLists.txt \
  licensing.css \
  licensing.qdocconf \
  licensing-html.qdocconf \
  licensing.qrc

QMAKE_DIR = $$dirname(QMAKE_QMAKE)

licensing_html.target = html/licensing.html
licensing_html.commands = \
  $$shell_quote($$QMAKE_DIR/qdoc) $$shell_quote($$PWD/licensing.qdocconf) -outputdir $$shell_quote($$OUT_PWD/html)
licensing_html.depends = $$LICENSING_SRCS Makefile

licensing_qrc.target = licensing.qrc
licensing_qrc.commands = \
  $(COPY_FILE) $$shell_quote($$PWD/licensing.qrc) licensing.qrc
licensing_qrc.depends = $$PWD/licensing.qrc

licensing_qrc_cpp.target = licensing_qrc.cpp
licensing_qrc_cpp.commands = \
  $$shell_quote($$QMAKE_DIR/rcc) -name licensing licensing.qrc -o licensing_qrc.cpp
licensing_qrc_cpp.depends = $$licensing_html.target $$licensing_qrc.target

QMAKE_EXTRA_TARGETS += licensing_html licensing_qrc licensing_qrc_cpp
PRE_TARGETDEPS      += $$licensing_qrc_cpp.target
QMAKE_CLEAN         += $$licensing_qrc_cpp.target $$licensing_qrc.target

win32: LICENSING_LIB = $$OUT_PWD/lib"$$TARGET".lib
else:  LICENSING_LIB = $$OUT_PWD/lib"$$TARGET".a

LICENSING_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_" \
  "DEPENDPATH  += $$OUT_PWD" \
  "LIBS        += \"-L$$OUT_PWD\" -ldoc-licensing"

write_file($$OUT_PWD/licensing.pri, LICENSING_PRI)
