#
#    Copyright 2013, 2014 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = aux
CONFIG  += c++11
CONFIG  -= debug_and_release

CMAKE_TOOLCHAIN_FILE = $$clean_path($$OUT_PWD/../../toolchain.cmake)
if (exists($$CMAKE_TOOLCHAIN_FILE)) {
    CMAKE_ARGS      += "-DCMAKE_TOOLCHAIN_FILE=\"$$CMAKE_TOOLCHAIN_FILE\""
    clipper.depends += $$CMAKE_TOOLCHAIN_FILE
}

clipper.dir      = $$OUT_PWD/clipper
clipper.target   = $$clipper.dir/libpolyclipping.a
win32:!gcc: clipper.target   = $$clipper.dir/libpolyclipping.lib
clipper.commands = \
  mkdir -p "$$clipper.dir" && \
  cd "$$clipper.dir" && \
  if [ -d CMakeFiles -o -f CMakeCache.txt ] ; then rm -R CMake*; fi && \
  if [ -d Clipper-prefix ] ; then rm -R Clipper-prefix; fi && \
  cmake "$$PWD" $$CMAKE_ARGS && \
  PATH="$$NDK_TOOLCHAIN_PATH/bin:${PATH}" $(MAKE) VERBOSE=$(VERBOSE)

QMAKE_EXTRA_TARGETS += clipper
PRE_TARGETDEPS      += $$clipper.target
QMAKE_CLEAN         += $$clipper.target

CLIPPER_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_" \
  "DEPENDPATH  += $$clipper.dir/Clipper-prefix/src/Clipper/cpp" \
  "INCLUDEPATH += $$clipper.dir/Clipper-prefix/src/Clipper/cpp" \
  "LIBS        += \"-L$$clipper.dir\""

write_file($$OUT_PWD/clipper.pri, CLIPPER_PRI)

OTHER_FILES += \
  CMakeLists.txt \
  License.txt
